% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{addCenters}
\alias{addCenters}
\title{Add cluster centers to graph.}
\usage{
addCenters(graph, n.centers = NULL, center.coordinates = NULL,
  generator = NULL, ...)
}
\arguments{
\item{graph}{[\code{mcGP}]\cr
Multi-objective graph problem.}

\item{n.centers}{[\code{integer(1)}]\cr
Number of cluster centers.}

\item{center.coordinates}{[\code{matrix(n, 2)}]\cr
Matrix of center coordinates (each row is one point).
Default is \code{NULL}. If this is set, \code{n.centers} and \code{generator}
are ignored.}

\item{generator}{[\code{function(n, ...)}]\cr
Function used to generate cluster centers. The generator needs to expect the number
of points to generate as the first argument \code{n}. Additional control argument are
possible.}

\item{...}{[any]\cr
Additional arguments passed down to \code{generator}.}
}
\value{
[\code{mcGP}] Multi-objective graph problem.
}
\description{
Places \code{n.centers} cluster centers in the two-dimensional
euclidean plane by means of a \code{generator}, e.g., by Latin-Hypercube-Sampling (LHS).
}
\seealso{
Other graph generators: \code{\link{addCoordinates}},
  \code{\link{addWeights}}, \code{\link{mcGP}}
}
