% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpMCBoostSurv.R
\name{mlr_pipeops_mcboostsurv}
\alias{mlr_pipeops_mcboostsurv}
\alias{PipeOpMCBoostSurv}
\title{Multi-Calibrate a Learner's Prediction (Survival Model)}
\format{
\code{\link{R6Class}} inheriting from \code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}}.
}
\description{
Post-process a survival learner prediction using multi-calibration.
For more details, please refer to \url{https://arxiv.org/pdf/1805.12317.pdf} (Kim et al. 2018)
or the help for \code{\link{MCBoostSurv}}.
If no \code{init_predictor} is provided, the preceding learner's predictions
corresponding to the \code{prediction} slot are used as an initial predictor for \code{MCBoostSurv}.
}
\section{Construction}{
\preformatted{PipeOpMCBoostSurv$new(id = "mcboostsurv", param_vals = list())
}
\itemize{
\item \code{id} :: \code{character(1)}
Identifier of the resulting  object, default \code{"threshold"}.
\item \code{param_vals} :: named \code{list}\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would otherwise be set during construction.
See \code{MCBoostSurv} for a comprehensive description of all hyperparameters.
}
}

\section{Input and Output Channels}{

During training, the input and output are \code{"data"} and \code{"prediction"}, two \code{\link[mlr3proba:TaskSurv]{TaskSurv}}.
A \code{\link[mlr3proba:PredictionSurv]{PredictionSurv}} is required as input and returned as output during prediction.
}

\section{State}{

The \verb{$state} is a \code{MCBoostSurv} Object as obtained from \code{MCBoostSurv$new()}.
}

\section{Parameters}{

\itemize{
\item \code{max_iter} :: \code{integer}\cr
A integer specifying the number of multi-calibration rounds. Defaults to 5.
}
}

\section{Fields}{

Only fields inherited from \code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}}.
}

\section{Methods}{

Only methods inherited from \code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}}.
}

\examples{
library(mlr3)
library(mlr3pipelines)
# Attention: gunion inputs have to be in the correct order for now.
\dontrun{
gr = gunion(list(
  "data" = po("nop"),
  "prediction" = po("learner_pred", lrn("surv.ranger"))
)) \%>>\%
  PipeOpMCBoostSurv$new()
tsk = tsk("rats")
tid = sample(1:300, 100)
gr$train(tsk$clone()$filter(tid))
gr$predict(tsk$clone()$filter(setdiff(1:300, tid)))
}
}
\seealso{
https://mlr3book.mlr-org.com/list-pipeops.html

Other PipeOps: 
\code{\link{mlr_pipeops_mcboost}}
}
\concept{PipeOps}
\section{Super class}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{PipeOpMCBoostSurv}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{predict_type}}{Predict type of the PipeOp.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{PipeOpMCBoostSurv$new()}}
\item \href{#method-clone}{\code{PipeOpMCBoostSurv$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict">}\href{../../mlr3pipelines/html/PipeOp.html#method-predict}{\code{mlr3pipelines::PipeOp$predict()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print">}\href{../../mlr3pipelines/html/PipeOp.html#method-print}{\code{mlr3pipelines::PipeOp$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train">}\href{../../mlr3pipelines/html/PipeOp.html#method-train}{\code{mlr3pipelines::PipeOp$train()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialize a Multi-Calibration PipeOp (for Survival).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpMCBoostSurv$new(id = "mcboostsurv", param_vals = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{\link{character}} \cr
The \code{PipeOp}'s id. Defaults to "mcboostsurv".}

\item{\code{param_vals}}{\code{\link{list}} \cr
List of hyperparameters for the \code{PipeOp}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpMCBoostSurv$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
