% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcen.r
\name{get_best_cvm}
\alias{get_best_cvm}
\title{Gets the index position for the model with the smallest cross-validation error.}
\usage{
get_best_cvm(model)
}
\arguments{
\item{model}{The cv.mcen object.}
}
\value{
Returns the index for the model with the smallest cross-validation error.
}
\description{
Gets the index position for the model with the smallest cross-validation error.
}
\examples{
\donttest{
x <- matrix(rnorm(400),ncol=4)
beta <- beta <- matrix(c(1,1,0,0,0,0,-1,-1,0,0,-1,-1,1,1,0,0),ncol=4)
y <- x\%*\%beta + rnorm(400) 
mcen_fit <- cv.mcen(x,y,ky=2,gamma_y=3)
get_best_cvm(mcen_fit)
}
}
\author{
Ben Sherwood <ben.sherwood@ku.edu>, Brad Price <brad.price@mail.wvu.edu>
}
