% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dists.R
\name{dists.mcgf}
\alias{dists.mcgf}
\alias{`dists<-`}
\alias{dists<-}
\title{Calculating distance matrices for an \code{mcgf} object}
\usage{
\method{dists}{mcgf}(x, ...)

dists(x) <- value
}
\arguments{
\item{x}{An \code{mcgf} object.}

\item{...}{Additional parameters or attributes.}

\item{value}{List of signed distance matrices, outputted from \code{\link[=dists]{dists()}}.}
}
\value{
A list of signed distance matrices: \code{h} (Euclidean), \code{h1}
(horizontal), and \code{h2} (vertical).
}
\description{
Calculating distance matrices for an \code{mcgf} object
}
\details{
If the \code{dists} attribute is available in \code{x}, it will be printed. Otherwise
\code{dists} will be calculated based on the \code{locations} attribute.
}
\examples{
data <- cbind(S1 = 1:5, S2 = 4:8, S3 = 5:9)
lon <- c(110, 120, 130)
lat <- c(50, 55, 60)
locations <- cbind(lon, lat)
obj <- mcgf(data = data, locations = locations)
obj
dists(obj)
dists(obj) <- dists(obj)
obj
}
