% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcglm.R
\docType{data}
\name{soil}
\alias{soil}
\title{Soil Chemistry Properties Data}
\format{
a \code{data.frame} with 250 records and 9 variables.
}
\source{
Bonat, W. H. (2018). Multiple Response Variables Regression
Models in R: The mcglm Package. Journal of Statistical Software, 84(4):1--30.
}
\usage{
data(soil)
}
\description{
Soil chemistry properties measured on a regular grid with
10 x 25 points spaced by 5 meters.

\itemize{

\item \code{COORD.X} - X coordinate.

\item \code{COORD.Y} - Y coordinate.

\item \code{SAND} - Sand portion of the sample.

\item \code{SILT} - Silt portion of the sample.

\item \code{CLAY} - Clay portion of the sample.

\item \code{PHWATER} - Soil pH at water.

\item \code{CA} - Calcium content.

\item \code{MG} - Magnesium content.

\item \code{K} - Potassio content.
}
}
\examples{
data(soil, package="mcglm")
neigh <- spdep::tri2nb(soil[,1:2])
## Sptail model
## Z1 <- mc_car(neigh) take too long
Z1 <- mc_id(soil)
# Linear predictor
form.ca <- CA ~ COORD.X*COORD.Y + SAND + SILT + CLAY + PHWATER
fit.ca <- mcglm(linear_pred = c(form.ca), matrix_pred = list(Z1),
               link = "log", variance = "tweedie", covariance = "inverse",
               power_fixed = TRUE, data = soil,
               control_algorith = list(max_iter = 1000, tuning = 0.1,
               verbose = FALSE, tol = 1e-03))
## mc_compute_rho(fit.ca) only for spatial model

}
\keyword{datasets}
