% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_mcglm.R
\name{fit_mcglm}
\alias{fit_mcglm}
\title{Chaser and Reciprocal Likelihood Algorithms}
\source{
Bonat, W. H. and Jorgensen, B. (2016) Multivariate
    covariance generalized linear models.
    Journal of Royal Statistical Society - Series C 65:649--675.

Bonat, W. H. (2018). Multiple Response Variables Regression
Models in R: The mcglm Package. Journal of Statistical Software, 84(4):1--30.
}
\usage{
fit_mcglm(list_initial, list_link, list_variance,
         list_covariance, list_X, list_Z, list_offset,
         list_Ntrial, list_power_fixed, list_sparse,
         y_vec, correct, max_iter, tol, method,
         tuning, verbose, weights)
}
\arguments{
\item{list_initial}{a list of initial values for regression and
covariance parameters.}

\item{list_link}{a list specifying the link function names. \cr
Options are: \code{"logit"}, \code{"probit"}, \code{"cauchit"},
\code{"cloglog"}, \code{"loglog"}, \code{"identity"}, \code{"log"},
\code{"sqrt"}, \code{"1/mu^2"} and \code{"inverse"}. \cr
See \code{\link{mc_link_function}} for details.
Default \code{link = "identity"}.}

\item{list_variance}{a list specifying the variance function names.
Options are: \code{"constant"}, \code{"tweedie"},
\code{"poisson_tweedie"}, \code{"binomialP"} and \code{"binomialPQ"}.
See \code{\link{mc_variance_function}} for details.
Default \code{variance = "constant"}.}

\item{list_covariance}{a list of covariance function names. Options
are: \code{"identity"}, \code{"inverse"} and \code{"expm"}.
Default \code{covariance = "identity"}.}

\item{list_X}{a list of design matrices.
See \code{\link[stats]{model.matrix}} for details.}

\item{list_Z}{a list of knowm matrices to compose the matrix linear
predictor.}

\item{list_offset}{a list of offset values. Default NULL.}

\item{list_Ntrial}{a list of number of trials, useful only when
analysing binomial data. Default 1.}

\item{list_power_fixed}{a list of logicals indicating if the power
parameters should be estimated or not. Default \code{power_fixed = TRUE}.}

\item{list_sparse}{a list of logicals indicating if the matrices
should be set up as sparse matrices. This argument is useful only
when using exponential-matrix covariance link function.
In the other cases the algorithm detects automatically if the matrix
should be sparse or not.}

\item{y_vec}{a vector of the stacked response variables.}

\item{correct}{a logical indicating if the algorithm will use the
correction term or not. Default \code{correct = FALSE}.}

\item{max_iter}{maximum number of iterations. Default \code{max_iter = 20}.}

\item{tol}{a numeric specyfing the tolerance. Default \code{tol = 1e-04}.}

\item{method}{a string specyfing the method used to fit the models
(\code{"chaser"} or \code{"rc"}). Default \code{method = "chaser"}.}

\item{tuning}{a numeric value in general close to zero for the rc
method and close to 1 for the chaser method. This argument control
the step-length. Default \code{tuning = 1}.}

\item{verbose}{a logical if TRUE print the values of the covariance
parameters used on each iteration. Default \code{verbose = FALSE}}

\item{weights}{Vector of weights for model fitting.}
}
\value{
A list with regression and covariance parameter estimates.
Details about the estimation procedures as iterations, sensitivity,
variability are also provided. In general the users do not need to
use this function directly. The \code{\link{mcglm}} provides GLM
interface for fitting \code{mcglm}.
}
\description{
This function implements the two main algorithms used
for fitting multivariate covariance generalized linear models.
The chaser and the reciprocal likelihood algorithms.
}
\seealso{
\code{mcglm}, \code{mc_matrix_linear_predictor},
 \code{mc_link_function} and \cr \code{mc_variance_function}.
}
\author{
Wagner Hugo Bonat, \email{wbonat@ufpr.br}
}
