% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/converged.R
\name{converged.mcmcrs}
\alias{converged.mcmcrs}
\title{Converged}
\usage{
\method{converged}{mcmcrs}(
  x,
  rhat = 1.1,
  esr = 0.33,
  by = "all",
  as_df = FALSE,
  bound = FALSE,
  na_rm = FALSE,
  ...
)
}
\arguments{
\item{x}{An object.}

\item{rhat}{The maximum rhat value.}

\item{esr}{The minimum effective sampling rate.}

\item{by}{A string indicating whether to determine by
"term", "parameter" or "all".}

\item{as_df}{A flag indicating whether to return the values as a
data frame versus a named list.}

\item{bound}{flag specifying whether to bind mcmcrs objects by their chains before calculating rhat.}

\item{na_rm}{A flag specifying whether to ignore missing values.}

\item{...}{Other arguments passed to methods.}
}
\value{
A logical scalar indicating whether the object has converged.
}
\description{
Tests whether an object has converged.
}
\examples{
converged(mcmcrs(mcmcr_example, mcmcr_example))
converged(mcmcrs(mcmcr_example, mcmcr_example), bound = TRUE)
}
\seealso{
Other convergence: 
\code{\link[universals]{converged_pars}()},
\code{\link[universals]{converged_terms}()},
\code{\link[universals]{esr_pars}()},
\code{\link[universals]{esr_terms}()},
\code{\link[universals]{esr}()},
\code{\link[universals]{rhat_pars}()},
\code{\link[universals]{rhat_terms}()},
\code{\link[universals]{rhat}()}
}
