% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conjugate_gradients.R
\name{setup_CG_sampler}
\alias{setup_CG_sampler}
\title{Set up conjugate gradient sampler}
\usage{
setup_CG_sampler(mbs, X, sampler, control = CG_control())
}
\arguments{
\item{mbs}{block component containing several model components.}

\item{X}{design matrix.}

\item{sampler}{sampler object as created by \code{\link{create_sampler}}.}

\item{control}{a list of options for the conjugate gradient algorithm that can be passed
using function \code{\link{CG_control}}.}
}
\value{
An environment with precomputed quantities and functions for multiplication
  by A and by an (inverse) preconditioning matrix.
}
\description{
Set up conjugate gradient sampler
}
\references{
A. Nishimura and M.A. Suchard (2022).
   Prior-preconditioned conjugate gradient method for accelerated Gibbs sampling in
   "large n, large p" Bayesian sparse regression.
   Journal of the American Statistical Association, 1-14.
}
\keyword{internal}
