% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/targets.R
\name{calc_width}
\alias{calc_width}
\title{Calculate Average Width of Confidence Intervals and its Monte Carlo Standard Error}
\usage{
calc_width(lower_bound, upper_bound)
}
\arguments{
\item{lower_bound}{A numeric vector of lower bounds of confidence intervals.}

\item{upper_bound}{A numeric vector of upper bounds of confidence intervals, corresponding to `lower_bound`.}
}
\value{
A list with two components: `width`, the average width of the confidence intervals, and
`width_mcse`, the Monte Carlo Standard Error of the average width. This MCSE provides a quantification
of the uncertainty in the average width estimate.
}
\description{
This function computes the average width of a set of confidence intervals, represented by their
lower and upper bounds, along with the Monte Carlo Standard Error (MCSE) of this average width.
The average width provides insight into the precision of the estimation process, with narrower
intervals typically indicating more precise estimates. The MCSE of the width offers a measure of
the uncertainty associated with the average width calculation, useful for assessing the variability
of interval estimates across simulations or bootstrap samples.
}
\examples{
set.seed(123) # For reproducibility
estimates <- rnorm(100, mean = 50, sd = 10)
ci_lower <- estimates - 1.96 * 10
ci_upper <- estimates + 1.96 * 10
width_info <- calc_width(ci_lower, ci_upper)
print(width_info)
}
