% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcvis.R
\name{mcvis}
\alias{mcvis}
\title{Multi-collinearity Visualization}
\usage{
mcvis(
  X,
  sampling_method = "bootstrap",
  standardise_method = "studentise",
  times = 1000L,
  k = 10L
)
}
\arguments{
\item{X}{A matrix of regressors (without intercept terms).}

\item{sampling_method}{The resampling method for the data.
Currently supports 'bootstrap' or 'cv' (cross-validation).}

\item{standardise_method}{The standardisation method for the data.
Currently supports 'euclidean' (default, centered by mean and divide by Euclidiean length)
and 'studentise' (centred by mean and divide by standard deviation)
and 'none' (no standardisation)}

\item{times}{Number of resampling runs we perform. Default is set to 1000.}

\item{k}{Number of partitions in averaging the MC-index. Default is set to 10.}
}
\value{
A list of outputs:
\itemize{
\item{t_square:}{The t^2 statistics for the regression between the VIFs and the tau's.}
\item{MC:}{The MC-indices}
\item{col_names:}{Column names (export for plotting purposes)}
}
}
\description{
Multi-collinearity Visualization
}
\examples{
set.seed(1)
p = 10
n = 100
X = matrix(rnorm(n*p), ncol = p)
X[,1] = X[,2] + rnorm(n, 0, 0.1)
mcvis_result = mcvis(X = X)
mcvis_result
}
\author{
Chen Lin, Kevin Wang, Samuel Mueller
}
