% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcv.R
\name{pcv}
\alias{pcv}
\title{Compute matrix with pseudo-validation set}
\usage{
pcv(
  x,
  ncomp = min(round(nrow(x)/nseg) - 1, col(x), 20),
  nseg = 4,
  scale = FALSE
)
}
\arguments{
\item{x}{matrix with calibration set (IxJ)}

\item{ncomp}{number of components for PCA decomposition}

\item{nseg}{number of segments in cross-validation}

\item{scale}{logical, standardize columns of X prior to decompositon or not}
}
\value{
Pseudo-validation matrix (IxJ)
}
\description{
The method computes pseudo-validation matrix Xpv, based on PCA decomposition of calibration set X
and systematic (venetian blinds) cross-validation. It is assumed that data rows are ordered
correctly, so systematic cross-validation can be applied.

All details can be found in [1]
}
\references{
1. Kucheryavskiy, S., Zhilin, S., Rodionova, O., & Pomerantsev, A.
Procrustes Cross-Validation—A Bridge between Cross-Validation and Independent Validation Sets.
Analytical Chemistry, 92 (17), 2020. pp.11842–11850. DOI: 10.1021/acs.analchem.0c02175
}
