/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.initial;

import multidendrograms.errors.MethodError;
import multidendrograms.types.MethodType;

public abstract class MethodName {
    public static String toName(MethodType methodType) {
        String string = "";
        switch (methodType) {
            case VERSATILE_LINKAGE: {
                string = "Versatile Linkage";
                break;
            }
            case SINGLE_LINKAGE: {
                string = "Single Linkage";
                break;
            }
            case COMPLETE_LINKAGE: {
                string = "Complete Linkage";
                break;
            }
            case ARITHMETIC_LINKAGE: {
                string = "Arithmetic Linkage";
                break;
            }
            case GEOMETRIC_LINKAGE: {
                string = "Geometric Linkage";
                break;
            }
            case HARMONIC_LINKAGE: {
                string = "Harmonic Linkage";
                break;
            }
            case CENTROID: {
                string = "Centroid";
                break;
            }
            case WARD: {
                string = "Ward";
                break;
            }
            case BETA_FLEXIBLE: {
                string = "Beta Flexible";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public static String toShortName(MethodType methodType) {
        String string = "";
        switch (methodType) {
            case VERSATILE_LINKAGE: {
                string = "vl";
                break;
            }
            case SINGLE_LINKAGE: {
                string = "sl";
                break;
            }
            case COMPLETE_LINKAGE: {
                string = "cl";
                break;
            }
            case ARITHMETIC_LINKAGE: {
                string = "al";
                break;
            }
            case GEOMETRIC_LINKAGE: {
                string = "gl";
                break;
            }
            case HARMONIC_LINKAGE: {
                string = "hl";
                break;
            }
            case CENTROID: {
                string = "cd";
                break;
            }
            case WARD: {
                string = "wd";
                break;
            }
            case BETA_FLEXIBLE: {
                string = "bf";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public static MethodType toMethodType(String string) throws MethodError {
        MethodType methodType;
        String string2 = string.toUpperCase();
        if (string2.equals("VL") || string2.equals("VERSATILE_LINKAGE")) {
            methodType = MethodType.VERSATILE_LINKAGE;
        } else if (string2.equals("SL") || string2.equals("SINGLE_LINKAGE")) {
            methodType = MethodType.SINGLE_LINKAGE;
        } else if (string2.equals("CL") || string2.equals("COMPLETE_LINKAGE")) {
            methodType = MethodType.COMPLETE_LINKAGE;
        } else if (string2.equals("AL") || string2.equals("ARITHMETIC_LINKAGE")) {
            methodType = MethodType.ARITHMETIC_LINKAGE;
        } else if (string2.equals("GL") || string2.equals("GEOMETRIC_LINKAGE")) {
            methodType = MethodType.GEOMETRIC_LINKAGE;
        } else if (string2.equals("HL") || string2.equals("HARMONIC_LINKAGE")) {
            methodType = MethodType.HARMONIC_LINKAGE;
        } else if (string2.equals("CD") || string2.equals("CENTROID")) {
            methodType = MethodType.CENTROID;
        } else if (string2.equals("WD") || string2.equals("WARD")) {
            methodType = MethodType.WARD;
        } else if (string2.equals("BF") || string2.equals("BETA_FLEXIBLE")) {
            methodType = MethodType.BETA_FLEXIBLE;
        } else {
            throw new MethodError("Error: unknown method '" + string2 + "'");
        }
        return methodType;
    }
}

