/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.core.clusterings;

import multidendrograms.core.clusterings.HierarchicalClustering;
import multidendrograms.core.definitions.Dendrogram;
import multidendrograms.core.definitions.SymmetricMatrix;

public abstract class LanceWilliams
extends HierarchicalClustering {
    public LanceWilliams(SymmetricMatrix symmetricMatrix, String[] stringArray, boolean bl, int n) {
        super(symmetricMatrix, stringArray, bl, n);
    }

    @Override
    protected double calculateProximity(Dendrogram dendrogram, Dendrogram dendrogram2) {
        return this.alphaTerm(dendrogram, dendrogram2) + this.betaTerm(dendrogram, dendrogram2) + this.betaTerm(dendrogram2, dendrogram);
    }

    private double alphaTerm(Dendrogram dendrogram, Dendrogram dendrogram2) {
        double d = 0.0;
        for (int i = 0; i < dendrogram.numberOfSubroots(); ++i) {
            Dendrogram dendrogram3 = dendrogram.getSubroot(i);
            for (int j = 0; j < dendrogram2.numberOfSubroots(); ++j) {
                Dendrogram dendrogram4 = dendrogram2.getSubroot(j);
                double d2 = this.getAlpha(dendrogram, dendrogram3, dendrogram2, dendrogram4);
                double d3 = this.rootsProximity(dendrogram3, dendrogram4);
                d += d2 * d3;
            }
        }
        return d;
    }

    protected abstract double getAlpha(Dendrogram var1, Dendrogram var2, Dendrogram var3, Dendrogram var4);

    private double betaTerm(Dendrogram dendrogram, Dendrogram dendrogram2) {
        double d = 0.0;
        for (int i = 0; i < dendrogram.numberOfSubroots() - 1; ++i) {
            Dendrogram dendrogram3 = dendrogram.getSubroot(i);
            for (int j = i + 1; j < dendrogram.numberOfSubroots(); ++j) {
                Dendrogram dendrogram4 = dendrogram.getSubroot(j);
                double d2 = this.getBeta(dendrogram, dendrogram3, dendrogram4, dendrogram2);
                double d3 = this.rootsProximity(dendrogram3, dendrogram4);
                d += d2 * d3;
            }
        }
        return d;
    }

    protected abstract double getBeta(Dendrogram var1, Dendrogram var2, Dendrogram var3, Dendrogram var4);
}

