# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Create Similarity Matrix
#' @description Constructs a similarity matrix of the pairwise coclustering 
#' rate.
#' @param allocations Matrix of sampled partitions. Columns correspond to 
#' items/samples being clustered, each row is a sampled partition. 
#' @return A symmetric N x N matrix (for N rows in allocations) describing 
#' the fraction of iterations for which each pairwise combination of points are
#' assigned the same label.
#' @examples
#' 
#' N <- 100
#' X <- matrix(c(rnorm(N, 0, 1), rnorm(N, 3, 1)), ncol = 2, byrow = TRUE)
#' Y <- matrix(c(rnorm(N, 0, 1), rnorm(N, 3, 1)), ncol = 2, byrow = TRUE)
#'
#' truth <- c(rep(1, N / 2), rep(2, N / 2))
#' data_modelled <- list(X, Y)
#'
#' V <- length(data_modelled)
#'
#' # This R is much too low for real applications
#' R <- 100
#' thin <- 5
#' burn <- 10
#'
#' K_max <- 10
#' K <- rep(K_max, V)
#' types <- rep("G", V)
#'
#' mcmc_out <- callMDI(data_modelled, R, thin, types, K = K)
#' createSimilarityMat(mcmc_out$allocations[, , 1])
#' @export
createSimilarityMat <- function(allocations) {
    .Call(`_mdir_createSimilarityMat`, allocations)
}

#' title Propose new non-negative value
#' description Propose new non-negative for sampling.
#' param x Current value to be proposed
#' param window The proposal window
#' return new double
NULL

#' title The Inverse Gamma Distribution
#' description Random generation from the inverse Gamma distribution.
#' param shape Shape parameter.
#' param rate Rate parameter.
#' return Sample from invGamma(shape, rate).
NULL

#' title The Inverse Gamma Distribution
#' description Random generation from the inverse Gamma distribution.
#' param N Number of samples to draw.
#' param shape Shape parameter.
#' param rate Rate parameter.
#' return Sample from invGamma(shape, rate).
NULL

#' title The Gamma Distribution
#' description Random generation from the Gamma distribution.
#' param shape Shape parameter.
#' param rate Rate parameter.
#' return Sample from Gamma(shape, rate).
NULL

#' title The Gamma Distribution
#' description Random generation from the Gamma distribution.
#' param N Number of samples to draw.
#' param shape Shape parameter.
#' param rate Rate parameter.
#' return N samples from Gamma(shape, rate).
NULL

#' title The Half-Cauchy Distribution
#' description Random generation from the Half-Cauchy distribution.
#' See https://en.wikipedia.org/wiki/Cauchy_distribution#Related_distributions
#' param mu Location parameter.
#' param scale Scale parameter.
#' return Sample from HalfCauchy(mu, scale).
NULL

#' title The Half-Cauchy Distribution
#' description Random generation from the Half-Cauchy distribution.
#' See https://en.wikipedia.org/wiki/Cauchy_distribution#Related_distributions
#' param N The number of samples to draw
#' param mu Location parameter.
#' param scale Scale parameter.
#' return Sample from HalfCauchy(mu, scale).
NULL

#' title The Beta Distribution
#' description Random generation from the Beta distribution.
#' See https://en.wikipedia.org/wiki/Beta_distribution#Related_distributions.
#' Samples from a Beta distribution based using two independent gamma
#' distributions.
#' param a Shape parameter.
#' param b Shape parameter.
#' return Sample from Beta(a, b).
NULL

#' title The Beta Distribution
#' description Random generation from the Beta distribution.
#' See https://en.wikipedia.org/wiki/Beta_distribution#Related_distributions.
#' Samples from a Beta distribution based using two independent gamma
#' distributions.
#' param n The number of samples to draw.
#' param a Shape parameter.
#' param b Shape parameter.
#' return Sample from Beta(a, b).
NULL

#' title Metropolis acceptance step
#' description Given a probaility, randomly accepts by sampling from a uniform 
#' distribution.
#' param acceptance_prob Double between 0 and 1.
#' return Boolean indicating acceptance.
NULL

#' title Squared exponential function
#' description The squared exponential function as used in a covariance kernel.
#' param amplitude The amplitude parameter (double)
#' param length The length parameter (double)
#' param i Time point (unsigned integer)
#' param j Time point (unsigned integer)
#' return Squared exponential metric of (i, j)
NULL

#' title The Half-Cauchy Distribution
#' description Calculates the pdf of the Half-Cauchy distribution for value x.
#' See https://en.wikipedia.org/wiki/Cauchy_distribution#Related_distributions
#' param x Value to calculate the probability density of.
#' param mu Location parameter.
#' param scale Scale parameter.
#' return Sample from HalfCauchy(mu, scale).
NULL

#' @title Gamma log-likelihood
#' @description The log-likelihood of each element of a vector in a Gamma 
#' distribution parametrised with a shape and rate.
#' @param x - vector; the values to calculate the likelihood of.
#' @param shape - double; the shape of the Gamma distribution.
#' @param rate - double; the rate of the Gamma distribution
#' @return the log-likelihood of x in a Gamma with parameters shape and rate.
NULL

#' @title Gaussian log-likelihood
#' @description The log-likelihood function for a point in the univariate 
#' Gaussian distribution.
#' @param x - double; the sample to calculate the log likelihood of.
#' @param mu - double; the mean parameter of the Gaussian distribution.
#' @param sigma_2 - double; the standard deviation of the Gaussian distribution.
#' @return the normalised log-likelihood of x in a Gaussian distribution with 
#' parameters mu, sigma_2.
NULL

#' @title Multivariate normal log-likelihood for diagonal covariance matrix
#' @description The log-likelihood function for a vector in a Gaussian density 
#' with a diagonal covariance matrix
#' @param x - vec; the sample to calculate the log likelihood of.
#' @param mu - vec; the mean parameter of the Gaussian distribution.
#' @param sigma_2 - vec; the standard deviation of the Gaussian distribution.
#' @return the normalised log-likelihood of x in a Gaussian distribution with 
#' parameters mu, sigma_2.
NULL

#' @title The Half-Cauchy Distribution
#' @description Calculates the pdf of the Half-Cauchy distribution for value x.
#' See https://en.wikipedia.org/wiki/Cauchy_distribution#Related_distributions
#' @param x Value to calculate the probability density of.
#' @param mu Location parameter.
#' @param scale Scale parameter.
#' @return Density of x in HalfCauchy(mu, scale).
NULL

#' @title Gamma log-likelihood
#' @description Used in calculating model probability in Metropolis-Hastings 
#' algorithm when proposals are from the Gamma distribution.
#' @param x - double; the value to calculate the likelihood of.
#' @param shape - double; the shape of the Gamma distribution.
#' @param rate - double; the rate of the Gamma distribution
#' @return the log-likelihood of x in a Gamma with parameters shape 
#' and rate.
gammaLogLikelihood <- function(x, shape, rate) {
    .Call(`_mdir_gammaLogLikelihood`, x, shape, rate)
}

#' @title Inverse gamma log-likelihood
#' @description Used in calculating model probability in Metropolis-Hastings 
#' algorithm when proposals are from the inverse-Gamma distribution.
#' @param x - double; the value to calculate the likelihood of.
#' @param shape - double; the shape of the inverse-Gamma distribution.
#' @param scale - double; the scale of the inverse-Gamma distribution
#' @return the unnormalised log-likelihood of x in a inverse-Gamma with parameters 
#' shape and scale.
invGammaLogLikelihood <- function(x, shape, scale) {
    .Call(`_mdir_invGammaLogLikelihood`, x, shape, scale)
}

#' @title Wishart log-likelihood
#' @description Used in calculating model probability in Metropolis-Hastings 
#' algorithm when proposals are from the Wishart distribution.
#' @param X - matrix; the matrix to calculate the likelihood of.
#' @param V - matrix; the scale of the Wishart distribution.
#' @param n - double; the degrees of freedom for the Wishart distribution.
#' @param P - unsigned integer; the dimension of X.
#' @return the unnormalised log-likelihood of X in a Wishart with parameters V 
#' and n.
wishartLogLikelihood <- function(X, V, n, P) {
    .Call(`_mdir_wishartLogLikelihood`, X, V, n, P)
}

#' @title Inverse-Wishart log-likelihood
#' @description Used in calculating model probability in Metropolis-Hastings 
#' algorithm when proposals are from the Wishart distribution.
#' @param X - matrix; the matrix to calculate the likelihood of.
#' @param Psi - matrix; the scale of the inverse-Wishart distribution.
#' @param nu - double; the degrees of freedom for the inverse-Wishart distribution.
#' @param P - unsigned integer; the dimension of X.
#' @return the unnormalised log-likelihood of X in a inverse-Wishart with parameters Psi 
#' and nu.
invWishartLogLikelihood <- function(X, Psi, nu, P) {
    .Call(`_mdir_invWishartLogLikelihood`, X, Psi, nu, P)
}

#' @title Multivariate t log-likelihood
#' @description The log-likelihood function for a point in the multivariate t 
#' (MVT) distribution.
#' @param x - vector; the sample to calculate the log likelihood of.
#' @param mu - vector; the mean parameter of the MVT distribution.
#' @param Sigma - matrix; the scale matrix of the MVT distribution.
#' @param nu - double; the degrees of freedom for the MVT distribution.
#' @return the normalised log-likelihood of x in a MVT distribution with 
#' parameters mu, Sigma and nu.
mvtLogLikelihood <- function(x, mu, Sigma, nu) {
    .Call(`_mdir_mvtLogLikelihood`, x, mu, Sigma, nu)
}

#' @title Multivariate Normal log-likelihood
#' @description The log-likelihood function for a point in the multivariate 
#' Normal (MVN) distribution.
#' @param x - vector; the sample to calculate the log likelihood of.
#' @param mu - vector; the mean parameter of the MVN distribution.
#' @param Sigma - matrix; the covariance matrix of the MVN distribution.
#' @param is_sympd - boolean; is the covariance matrix positive definite (
#' calculations are faster if this is the case).
#' @return the normalised log-likelihood of x in a MVN distribution with 
#' parameters mu, Sigma.
pNorm <- function(x, mu, Sigma, is_sympd = TRUE) {
    .Call(`_mdir_pNorm`, x, mu, Sigma, is_sympd)
}

#' @title Call Multiple Dataset Integration
#' @description C++ function to perform MCMC sampling for MDI.
#' @param R The number of iterations to run for.
#' @param thin thinning factor for samples recorded.
#' @param Y The list of data matrices to perform integrative clustering upon 
#' with items to cluster in rows.
#' @param K Vector of the number of components to model in each view. This is the upper 
#' limit on the number of clusters that can be found.
#' @param mixture_types Character vector of densities used in each view
#' @param outlier_types Character vector of outlier components used in each 
#' view ('MVT' or 'None').
#' @param labels Matrix item labels to initialise from. Rows correspond to the
#' items being clustered, columns to views.
#' @param fixed Binary matrix of the items that are fixed in their initial
#' label.
#' @param proposal_windows List/field of vectors
#' @return Named list of the different quantities drawn by the sampler.
runMDI <- function(R, thin, Y, K, mixture_types, outlier_types, labels, fixed, proposal_windows) {
    .Call(`_mdir_runMDI`, R, thin, Y, K, mixture_types, outlier_types, labels, fixed, proposal_windows)
}

