% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_analyses.R
\name{define_analyses}
\alias{define_analyses}
\title{Assess Analyses Definitions}
\usage{
define_analyses(deviceevents, device_level, event_level = NULL,
  exposure = NULL, date_level = "months", date_level_n = 1,
  covariates = "_none_", times_to_calc = NULL, invivo = FALSE,
  prior = NULL)
}
\arguments{
\item{deviceevents}{A device-events object of class \code{mds_de}, created by
a call to \code{deviceevent()}.}

\item{device_level}{String value indicating the source device variable name
to analyze by. If \code{exposure} is specified, \code{exposure} data will be
matched by \code{device_level}. If a hierarchy of 2 or more are present,
see Details for important information.

Example: If the \code{deviceevents} variable column is \code{device_1} where
the source variable name for \code{device_1} is \code{'Device Code'}, specify
\code{device_level='Device Code'}.}

\item{event_level}{String value indicating the source event variable name to
analyze by. Note that \code{event_level} is not matched to \code{exposure}.
If a hierarchy of 2 or more are present, see Details for important 
information.

Example: If the \code{deviceevents} variable column is \code{event_1} where
the source variable name for \code{event_1} is \code{'Event Code'}, specify
\code{event_level='Event Code'}.

Default: \code{NULL} will not analyze by event.}

\item{exposure}{Optional exposure object of class \code{mds_e}. See details
for how exposure analyses definitions are handled.

Default: \code{NULL} will not consider inclusion of exposure.}

\item{date_level}{String value for the primary date unit to analyze by. Can
be either \code{'months'} or \code{'days'}.

Default: \code{'months'}}

\item{date_level_n}{Numeric value indicating the number of \code{date_level}s
to analyze by.

Example: \code{date_level='months'} and \code{date_level_n=3} indicates
analysis on a quarterly level.

Default: \code{1}}

\item{covariates}{Character vector specifying names of covariates to also
define analyses for. Acceptable names are covariate variables specified
in \code{deviceevents}. If the covariate is a factor, additional subgroup
analyses will be defined at each level of the factor. \code{"_none_"}
specifies no covariates, while \code{"_all_"} are all covariates specified in
\code{deviceevents}. See details for more.

Example: \code{c("Country", "Region")}

Default: \code{"_none_"} specifies no covariates.}

\item{times_to_calc}{Integer value indicating the number of date units
counting backwards from the latest date to define analyses for. If
\code{prior} is specified, \code{times_to_calc} will be ignored.

Example 1: \code{times_to_calc=12} with \code{date_level="months"} and
\code{date_level_n=1} defines analyses for the last year by month.

Example 2: \code{times_to_calc=8} with \code{date_level="months"} and
\code{date_level_n=3} defines analyses for the 2 years by quarter.

Default: \code{NULL} will define analyses across all available time.}

\item{invivo}{Logical value indicating whether to include \code{time_invivo}
from \code{deviceevents} in the analysis definition. See details for more.

Default: \code{FALSE} will not include \code{time_invivo} in the analysis
definition.}

\item{prior}{Future placeholder, currently not used.}
}
\value{
A list of defined analyses of class \code{mds_das}.
Each list item, indexed by a numeric key, defines a set of analyses for a
unique combination of device, event, and covariate level. Each list item is
of the class \code{mds_da}.
Attributes of class \code{mds_das} are as follows:
\describe{
  \item{date_level}{Defined value for \code{date_level}}
  \item{date_level_n}{Defined value for \code{date_level_n}}
  \item{device_level}{Defined value for \code{device_level}}
  \item{event_level}{Defined value for \code{event_level}}
  \item{times_to_calc}{Defined value for \code{times_to_calc}}
  \item{prior_used}{Boolean for whether \code{prior} was specified.}
  \item{timestamp}{System time when the analyses were defined.}
}
}
\description{
Define analyses based on an MD-PMS device-event data frame and, optionally,
an MD-PMS exposure data frame. See Details for how to use.
}
\details{
\code{define_analyses()} is a prerequisite to calling
\code{time_series()}. This function enumerates all possible analyses based
on input device-event (\code{deviceevent()}) and, optionally, 
exposure (\code{exposure()}) data frames. An analysis is defined as a set of
instructions specifying at minimum the device level, event level, the date
range of analysis, and the date unit. Additional instructions include the
covariate level, time in-vivo status, and exposure levels.

By separating the analysis enumeration (\code{define_analyses()}) from the
generation of the time series (\code{time_series()}), the user may rerun
the analyses on different datasets and/or filter the analyses to only those
of interest.

The analyses definitions will always include rollup levels for each
of \code{device_level}, \code{event_level} (if specified), and
\code{covariates}. Rollups are analyses at all device, event, and/or
covariate levels. These rollup analyses will be indicated by the keyword
'All' in the analysis definition.

When a hierarchy of 2 or more variables for either \code{device_level} or
\code{event_level} are present in \code{deviceevents}, 
\code{define_analyses()} will enforce the 1-level-up parent level ONLY.
Additional higher parent levels are not currently enforced, thus the user is 
advised to uniquely name the 1-level-up parent level. The parent level
DOES NOT ROLLUP currently because the parent level is intended to separate
disparate data and devices. This may change in the future.

If \code{exposure} is specified, any available \code{match_levels} will be
used to calculate the appropriate timeframe for analyses. The exception are
the special rollup analyses (see prior paragraph).

When \code{covariates} are specified, a special rollup analysis definition
will always be defined that does not consider the covariates at all. This
analysis can be identified by \code{covariate='Data'} and
\code{covariate_level='All'} in the output \code{mds_da} object.

When \code{covariates} are specified and there is no variation in the
distribution of covariate values (e.g. all males, all 10, all missing) in the
device- and event-specific dataset, these specific analyses will be dropped.

When factor \code{covariates} are specified, covariate-level analyses may be
defined two ways: 1) detect an overall covariate level effect,
also known as a 3-dimensional analysis, and 2) subset the data by each
level of the covariate, also known as a subgroup analysis. 1) will be
denoted as \code{covariate_level='All'} in the output \code{mds_da} object,
while 2) will specify the factor level in \code{covariate_level}.

If \code{invivo=TRUE}, \code{define_analyses()} will first verify if data
exists in the \code{time_invivo} variable for the given \code{device_level},
\code{event_level}, and, if applicable, \code{covariates} level. If no data
exists, \code{invivo} will be implicitly assigned to \code{FALSE}.
}
\examples{
# Device-Events
de <- deviceevent(
  data_frame=maude,
  time="date_received",
  device_hierarchy=c("device_name", "device_class"),
  event_hierarchy=c("event_type", "medical_specialty_description"),
  key="report_number",
  covariates=c("region"),
  descriptors="_all_")
# Exposures
ex <- exposure(
  data_frame=sales,
  time="sales_month",
  device_hierarchy="device_name",
  match_levels="region",
  count="sales_volume")
# Defined Analyses - Simple example
da <- define_analyses(de, "device_name")
# Defined Analyses - Simple example with a quarterly analysis
da <- define_analyses(de, "device_name", date_level_n=3)
# Defined Analyses - Example with event type, exposures, and covariates
da <- define_analyses(de, "device_name", "event_type", ex, covariates="region")

}
