% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{define_algos}
\alias{define_algos}
\title{Set List of Algorithms to Run}
\usage{
define_algos(algos)
}
\arguments{
\item{algos}{Required named list of \code{mdsstat} algorithms to run. Each
named list element must be a single list of parameter values for the
algorithm named. The list of parameters may be an empty list (indicating the
default values) and must not contain the first parameter \code{df}. See
details and examples for more.}
}
\value{
Validated list of instructions that may be used in the
\code{\link{run_algos}} function.
}
\description{
Define any number of algorithms with various parameter settings and save as a
reusable set of instructions.
}
\details{
Each algorithm may be named multiple times (to
allow running of multiple parameter settings). Do not specify the \code{df}
parameter.
}
\examples{
x <- list(prr=list(),
  xbar=list(),
  xbar=list(ts_event=c(Rate="rate"), we_rule=2),
  poisson_rare=list(p_rate=0.3))
define_algos(x)
}
