% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edge_tax_comp.R
\name{edge_tax_comp}
\alias{edge_tax_comp}
\title{Taxonomic sum of linked nodes in edges across networks}
\usage{
edge_tax_comp(network_list, taxrank = "Phylum", label = "+", rel = TRUE)
}
\arguments{
\item{network_list}{a list with multiple networks; all the networks should be trans_network object created from \code{\link{trans_network}} class of microeco package.}

\item{taxrank}{default "Phylum"; Which taxonomic level is used for the sum of nodes in edges.}

\item{label}{default "+"; "+" or "-" or c("+", "-"); the edge label used for the selection of edges for the sum.}

\item{rel}{default TRUE; TRUE represents using ratio, the denominator is the number of selected edges; FALSE represents the absolute number of the sum of edges.}
}
\value{
data.frame
}
\description{
Taxonomic sum of linked nodes in edges across networks.
}
\examples{
data(soil_amp_network)
test <- edge_tax_comp(soil_amp_network)
# test is a microtable object

}
