% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mefd_fun.R
\name{mefd_read}
\alias{mefd_read}
\title{Lee datos de indicadores}
\usage{
mefd_read(url_ind = NULL, url_web = NULL, config = conf)
}
\arguments{
\item{url_ind}{url(s) de la bases de datos (.csv) del indicador}

\item{url_web}{url de página web del MEFD con lista de indicadores}

\item{config}{lista con parámetros de configuración (default)}
}
\value{
data.frame o lista de data.frames con datos de indicadores
}
\description{
Lee bases de datos (.csv) de indicadores a partir de página web (url_web) O
url de .csv (url_ind). El usuaRio debe eligir uno de los dos argumentos.
No es posible elegir ambos.
}
\examples{
mi_url <- paste0("https://estadisticas.educacion.gob.es/EducaDynPx/",
"educabase/index.htm?type=pcaxis&path=/no-universitaria/centros/",
"centrosyunid/series/unidades_esc&file=pcaxis&l=s0")

# Lectura desde página web (url_web)
df <- mefd_read(mi_url)

# Lectura de un indicador específico a partir de url del .csv (url_ind)
df <- mefd_read(url_ind = meta_mefd$url[190])

# Lectura de varios indicadores a partir del url del .csv (url_ind)
df <- mefd_read(url_ind=meta_mefd$url[c(1, 5, 17)])
}
