% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{grow_ba}
\alias{grow_ba}
\title{Barabási & Albert (2002) network growth model}
\usage{
grow_ba(n = 100L, m = 5L, power = 1)
}
\arguments{
\item{n}{Integer. Number of nodes in the network.}

\item{m}{Integer. Number of edges added for each incoming node.}

\item{power}{Numeric. Controls the selection of nodes by raising the degree
to this power.}
}
\value{
n x n adjacency matrix.
}
\description{
Grow networks using Barabási & Alberts's (2002) preferential
attachment model.
}
\examples{
# generate small graph
grow_ba(n = 6, m = 2)

\dontrun{
# generate large graph, flat degree distribution
grow_ba(n = 100, m = 10, p = .1)

# generate large graph, steep degree distribution
grow_ba(n = 100, m = 10, p = 10)
}

}
\references{
Barabási, A. L., & Albert, R. (1999). Emergence of scaling in random
networks. Science, 286(5439), 509-512.
}
