% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coerce_to_messydate.R
\name{as_messydate}
\alias{as_messydate}
\alias{as_messydate.Date}
\alias{as_messydate.POSIXct}
\alias{as_messydate.POSIXlt}
\alias{as_messydate.character}
\title{Coercion to messy dates}
\usage{
as_messydate(x)

\method{as_messydate}{Date}(x)

\method{as_messydate}{POSIXct}(x)

\method{as_messydate}{POSIXlt}(x)

\method{as_messydate}{character}(x)
}
\arguments{
\item{x}{A scalar or vector of a class that can be coerced into a Date,
such as \code{Date}, \code{POSIXct}, \code{POSIXlt}, or character.}
}
\value{
A \code{messydt} class object
}
\description{
These functions coerce different data classes into \code{messydt} class
}
\section{Methods (by class)}{
\itemize{
\item \code{Date}: Coerce from \code{Date} to \code{messydt} class

\item \code{POSIXct}: Coerce from \code{POSIXct} to \code{messydt} class

\item \code{POSIXlt}: Coerce from \code{POSIXlt} to \code{messydt} class

\item \code{character}: Coerce character date objects to \code{messydt} class
}}

\examples{
as_messydate("2021")
as_messydate("2021-02")
as_messydate("2021-02-01")
as_messydate("2021-02-01?")
as_messydate("2021-02-01~")
as_messydate("2021-02-01\%")
as_messydate("2021-02-01..2021-02-28")
as_messydate("{2021-02-01,2021-02-28}")
}
