% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operate.R
\name{operate}
\alias{operate}
\alias{+.messydt}
\alias{-.messydt}
\title{Arithmetic operations for messydates}
\usage{
\method{+}{messydt}(e1, e2)

\method{-}{messydt}(e1, e2)
}
\arguments{
\item{e1}{A messydate object}

\item{e2}{A numerical object.}
}
\value{
A messydates vector
}
\description{
These operations allow users to add or subtract dates messydate objects.
Messydate objects include incomplete or uncertain dates,
ranges of dates, negative dates, and date sets.
}
\examples{
d <- as_messydate(c("2008-03-25", "-2012-02-27", "2001-01?", "~2001",
"2001-01-01..2001-02-02", "{2001-01-01,2001-02-02}",
"2008-XX-31", "..2002-02-03", "2001-01-03..", "28 BC"))
tibble::tibble(date = d, add = d + 1, subtract = d - 1)
tibble::tibble(date = d, add = d + "1 year", subtract = d - "1 year")
}
