% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DivideTimeseries.R
\name{DivideTimeseries}
\alias{DivideTimeseries}
\title{Divides long timeseries for better reading}
\usage{
DivideTimeseries(g, x, n = 2, xlab = "x", ylab = "y")
}
\arguments{
\item{g}{ggplot object}

\item{x}{The vector that was used in g for the x axis (must be of class Date)}

\item{n}{Number of panels}

\item{xlab}{x axis label}

\item{ylab}{y axis label}
}
\value{
Draws a plot.
}
\description{
Long timeseries can be compressed to the point of being unreadable when
plotted on a page. This function takes a ggplot object of a timeseries and
divides it into panels so that the time dimension gets stretched for better
readability.
}
\examples{
library(ggplot2)
library(data.table)
gdata <- geopotential[lat == -30 & lon == 0]
g <- ggplot(gdata, aes(date, gh)) +
    geom_line() +
    geom_smooth() +
    scale_x_date(date_breaks = "1 year", date_labels = "\%b")
DivideTimeseries(g, gdata$date, n = 2, "Date", "Max Temperature")
}
\seealso{
Other ggplot2 helpers: \code{\link{MakeBreaks}},
  \code{\link{WrapCircular}}, \code{\link{geom_arrow}},
  \code{\link{geom_contour2}},
  \code{\link{geom_contour_fill}},
  \code{\link{geom_label_contour}},
  \code{\link{geom_relief}}, \code{\link{geom_streamline}},
  \code{\link{guide_colourstrip}},
  \code{\link{map_labels}}, \code{\link{reverselog_trans}},
  \code{\link{scale_divergent}},
  \code{\link{scale_longitude}}, \code{\link{stat_na}},
  \code{\link{stat_subset}}
}
\concept{ggplot2 helpers}
