% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MakeBreaks.R
\name{MakeBreaks}
\alias{MakeBreaks}
\alias{AnchorBreaks}
\title{Functions for making breaks}
\usage{
MakeBreaks(binwidth = NULL, bins = 10, exclude = NULL)

AnchorBreaks(anchor = 0, binwidth = NULL, exclude = NULL, bins = 10)
}
\arguments{
\item{binwidth}{width of breaks}

\item{bins}{number of bins, used if \code{binwidth = NULL}}

\item{exclude}{a vector of breaks to exclude}

\item{anchor}{anchor value}
}
\value{
A function that takes a range as argument and a binwidth as an optional argument
and returns a sequence of equally spaced intervals covering the range.
}
\description{
Functions that return functions suitable to use as the \code{breaks} argument in
ggplot2's continuous scales and in \link{geom_contour_fill}.
}
\details{
\code{MakeBreaks} is essentially an export of the default way
\link[ggplot2:geom_contour]{ggplot2::stat_contour} makes breaks.

\code{AnchorBreaks} makes breaks starting from an \code{anchor} value and covering
the range of the data according to \code{binwidth}.
}
\examples{

my_breaks <- MakeBreaks(10)
my_breaks(c(1, 100))
my_breaks(c(1, 100), 20)    # optional new binwidth argument ignored

MakeBreaks()(c(1, 100), 20)  # but is not ignored if initial binwidth is NULL

# One to one mapping between contours and breaks
library(ggplot2)
binwidth <- 20
ggplot(reshape2::melt(volcano), aes(Var1, Var2, z = value)) +
    geom_contour(aes(color = ..level..), binwidth = binwidth) +
    scale_color_continuous(breaks = MakeBreaks(binwidth))

#Two ways of getting the same contours. Better use the second one.
ggplot(reshape2::melt(volcano), aes(Var1, Var2, z = value)) +
    geom_contour2(aes(color = ..level..), breaks = AnchorBreaks(132),
                  binwidth = binwidth) +
    geom_contour2(aes(color = ..level..), breaks = AnchorBreaks(132, binwidth)) +
    scale_color_continuous(breaks = AnchorBreaks(132, binwidth))

}
\seealso{
Other ggplot2 helpers: 
\code{\link{DivideTimeseries}()},
\code{\link{WrapCircular}()},
\code{\link{geom_arrow}()},
\code{\link{geom_contour2}()},
\code{\link{geom_contour_fill}()},
\code{\link{geom_label_contour}()},
\code{\link{geom_relief}()},
\code{\link{geom_streamline}()},
\code{\link{guide_colourstrip}()},
\code{\link{map_labels}},
\code{\link{reverselog_trans}()},
\code{\link{scale_divergent}},
\code{\link{scale_longitude}},
\code{\link{stat_na}()},
\code{\link{stat_subset}()}
}
\concept{ggplot2 helpers}
