% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCountry.R
\name{getCountry}
\alias{getCountry}
\title{Filter environmental monitoring stations by country}
\usage{
getCountry(country, ...)
}
\arguments{
\item{country}{(character) Country(ies)/territory(ies) to filter environmental stations.}

\item{...}{auto-populates when called from \code{siteFinder()} wrapper}
}
\value{
A list comprising metadata of environmental monitoring stations from country(ies)/territory(ies) specified in \code{country}\cr
}
\description{
Return metadata of environmental monitoring stations from specific country(ies)/territory(ies) within the metScanR database.
}
\examples{
\dontrun{
#returns metadata from all environmental sites within the database from the United States
  getCountry(country="United States")
#returns metadata from all environmental sites within the database from the Italy and Portugal
  getCountry(country=c("Italy","Portugal"))}
}
\seealso{
\link[metScanR]{siteFinder}
\link[metScanR]{mapResults}
\link[metScanR]{metScanR_DB}
}
\author{
Josh Roberti \email{jaroberti87@gmail.com} \cr
}
