% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metacor.R
\name{metacor}
\alias{metacor}
\title{Meta-analysis of correlations}
\usage{
metacor(
  cor,
  n,
  studlab,
  data = NULL,
  subset = NULL,
  exclude = NULL,
  sm = gs("smcor"),
  level = gs("level"),
  level.ma = gs("level.ma"),
  fixed = gs("fixed"),
  random = gs("random") | !is.null(tau.preset),
  overall = fixed | random,
  overall.hetstat = fixed | random,
  hakn = gs("hakn"),
  adhoc.hakn = gs("adhoc.hakn"),
  method.tau = gs("method.tau"),
  method.tau.ci = gs("method.tau.ci"),
  tau.preset = NULL,
  TE.tau = NULL,
  tau.common = gs("tau.common"),
  prediction = gs("prediction"),
  level.predict = gs("level.predict"),
  null.effect = 0,
  method.bias = gs("method.bias"),
  backtransf = gs("backtransf"),
  text.fixed = gs("text.fixed"),
  text.random = gs("text.random"),
  text.predict = gs("text.predict"),
  text.w.fixed = gs("text.w.fixed"),
  text.w.random = gs("text.w.random"),
  title = gs("title"),
  complab = gs("complab"),
  outclab = "",
  subgroup,
  subgroup.name = NULL,
  print.subgroup.name = gs("print.subgroup.name"),
  sep.subgroup = gs("sep.subgroup"),
  test.subgroup = gs("test.subgroup"),
  prediction.subgroup = gs("prediction.subgroup"),
  byvar,
  keepdata = gs("keepdata"),
  warn.deprecated = gs("warn.deprecated"),
  control = NULL,
  ...
)
}
\arguments{
\item{cor}{Correlation.}

\item{n}{Number of observations.}

\item{studlab}{An optional vector with study labels.}

\item{data}{An optional data frame containing the study
information, i.e., cor and n.}

\item{subset}{An optional vector specifying a subset of studies to
be used.}

\item{exclude}{An optional vector specifying studies to exclude
from meta-analysis, however, to include in printouts and forest
plots.}

\item{sm}{A character string indicating which summary measure
(\code{"ZCOR"} or \code{"COR"}) is to be used for pooling of
studies.}

\item{level}{The level used to calculate confidence intervals for
individual studies.}

\item{level.ma}{The level used to calculate confidence intervals
for meta-analysis estimates.}

\item{fixed}{A logical indicating whether a fixed effect / common
effect meta-analysis should be conducted.}

\item{random}{A logical indicating whether a random effects
meta-analysis should be conducted.}

\item{overall}{A logical indicating whether overall summaries
should be reported. This argument is useful in a meta-analysis
with subgroups if overall results should not be reported.}

\item{overall.hetstat}{A logical value indicating whether to print
heterogeneity measures for overall treatment comparisons. This
argument is useful in a meta-analysis with subgroups if
heterogeneity statistics should only be printed on subgroup
level.}

\item{hakn}{A logical indicating whether the method by Hartung and
Knapp should be used to adjust test statistics and confidence
intervals.}

\item{adhoc.hakn}{A character string indicating whether an \emph{ad
hoc} variance correction should be applied in the case of an
arbitrarily small Hartung-Knapp variance estimate, see Details.}

\item{method.tau}{A character string indicating which method is
used to estimate the between-study variance \eqn{\tau^2} and its
square root \eqn{\tau}. Either \code{"DL"}, \code{"PM"},
\code{"REML"}, \code{"ML"}, \code{"HS"}, \code{"SJ"},
\code{"HE"}, or \code{"EB"}, can be abbreviated.}

\item{method.tau.ci}{A character string indicating which method is
used to estimate the confidence interval of \eqn{\tau^2} and
\eqn{\tau}. Either \code{"QP"}, \code{"BJ"}, or \code{"J"}, or
\code{""}, can be abbreviated.}

\item{tau.preset}{Prespecified value for the square root of the
between-study variance \eqn{\tau^2}.}

\item{TE.tau}{Overall effect used to estimate the between-study
variance tau-squared.}

\item{tau.common}{A logical indicating whether tau-squared should
be the same across subgroups.}

\item{prediction}{A logical indicating whether a prediction
interval should be printed.}

\item{level.predict}{The level used to calculate prediction
interval for a new study.}

\item{null.effect}{A numeric value specifying the effect under the
null hypothesis.}

\item{method.bias}{A character string indicating which test is to
be used. Either \code{"Begg"}, \code{"Egger"}, or
\code{"Thompson"}, can be abbreviated. See function
\code{\link{metabias}}.}

\item{backtransf}{A logical indicating whether results for Fisher's
z transformed correlations (\code{sm = "ZCOR"}) should be back
transformed in printouts and plots. If TRUE (default), results
will be presented as correlations; otherwise Fisher's z
transformed correlations will be shown.}

\item{text.fixed}{A character string used in printouts and forest
plot to label the pooled fixed effect estimate.}

\item{text.random}{A character string used in printouts and forest
plot to label the pooled random effects estimate.}

\item{text.predict}{A character string used in printouts and forest
plot to label the prediction interval.}

\item{text.w.fixed}{A character string used to label weights of
fixed effect model.}

\item{text.w.random}{A character string used to label weights of
random effects model.}

\item{title}{Title of meta-analysis / systematic review.}

\item{complab}{Comparison label.}

\item{outclab}{Outcome label.}

\item{subgroup}{An optional vector to conduct a meta-analysis with
subgroups.}

\item{subgroup.name}{A character string with a name for the
subgroup variable.}

\item{print.subgroup.name}{A logical indicating whether the name of
the subgroup variable should be printed in front of the group
labels.}

\item{sep.subgroup}{A character string defining the separator
between name of subgroup variable and subgroup label.}

\item{test.subgroup}{A logical value indicating whether to print
results of test for subgroup differences.}

\item{prediction.subgroup}{A logical indicating whether prediction
intervals should be printed for subgroups.}

\item{byvar}{Deprecated argument (replaced by 'subgroup').}

\item{keepdata}{A logical indicating whether original data (set)
should be kept in meta object.}

\item{warn.deprecated}{A logical indicating whether warnings should
be printed if deprecated arguments are used.}

\item{control}{An optional list to control the iterative process to
estimate the between-study variance \eqn{\tau^2}. This argument
is passed on to \code{\link[metafor]{rma.uni}}.}

\item{\dots}{Additional arguments (to catch deprecated arguments).}
}
\value{
An object of class \code{c("metacor", "meta")} with corresponding
\code{print}, \code{summary}, and \code{forest} functions. The
object is a list containing the following components:
\item{cor, n, studlab, exclude,}{As defined above.}
\item{sm, level, level.ma,}{As defined above.}
\item{fixed, random,}{As defined above.}
\item{hakn, adhoc.hakn, method.tau, method.tau.ci,}{As defined above.}
\item{tau.preset, TE.tau, method.bias,}{As defined above.}
\item{method.bias, tau.common, title, complab, outclab,}{As defined
  above.}
\item{subgroup, subgroup.name, print.subgroup.name, sep.subgroup}{As defined above.}
\item{TE, seTE}{Either Fisher's z transformation of correlations
  (\code{sm = "ZCOR"}) or correlations (\code{sm="COR"}) for
  individual studies.}
\item{lower, upper}{Lower and upper confidence interval limits for
  individual studies.}
\item{zval, pval}{z-value and p-value for test of effect in
  individual studies.}
\item{w.fixed, w.random}{Weight of individual studies (in fixed and
  random effects model).}
\item{TE.fixed, seTE.fixed}{Estimated overall effect (Fisher's z
  transformation of correlation or correlation) and standard error
  (fixed effect model).}
\item{lower.fixed, upper.fixed}{Lower and upper confidence interval
  limits (fixed effect model).}
\item{statistic.fixed, pval.fixed}{z-value and p-value for test of
  overall effect (fixed effect model).}
\item{TE.random, seTE.random}{Estimated overall effect (Fisher's z
  transformation of correlation or correlation) and standard error
  (random effects model).}
\item{lower.random, upper.random}{Lower and upper confidence
  interval limits (random effects model).}
\item{statistic.random, pval.random}{z-value or t-value and
  corresponding p-value for test of overall effect (random effects
  model).}
\item{prediction, level.predict}{As defined above.}
\item{seTE.predict}{Standard error utilised for prediction
  interval.}
\item{lower.predict, upper.predict}{Lower and upper limits of
  prediction interval.}
\item{k}{Number of studies combined in meta-analysis.}
\item{Q}{Heterogeneity statistic Q.}
\item{df.Q}{Degrees of freedom for heterogeneity statistic.}
\item{pval.Q}{P-value of heterogeneity test.}
\item{tau2}{Between-study variance \eqn{\tau^2}.}
\item{se.tau2}{Standard error of \eqn{\tau^2}.}
\item{lower.tau2, upper.tau2}{Lower and upper limit of confidence
  interval for \eqn{\tau^2}.}
\item{tau}{Square-root of between-study variance \eqn{\tau}.}
\item{lower.tau, upper.tau}{Lower and upper limit of confidence
  interval for \eqn{\tau}.}
\item{H}{Heterogeneity statistic H.}
\item{lower.H, upper.H}{Lower and upper confidence limit for
 heterogeneity statistic H.}
\item{I2}{Heterogeneity statistic I\eqn{^2}.}
\item{lower.I2, upper.I2}{Lower and upper confidence limit for
  heterogeneity statistic I\eqn{^2}.}
\item{Rb}{Heterogeneity statistic R\eqn{_b}.}
\item{lower.Rb, upper.Rb}{Lower and upper confidence limit for
  heterogeneity statistic R\eqn{_b}.}
\item{df.hakn}{Degrees of freedom for test of effect for
  Hartung-Knapp method (only if \code{hakn = TRUE}).}
\item{method}{Pooling method: \code{"Inverse"}.}
\item{bylevs}{Levels of grouping variable - if \code{subgroup} is not
  missing.}
\item{TE.fixed.w, seTE.fixed.w}{Estimated effect and
  standard error in subgroups (fixed effect model) - if
  \code{subgroup} is not missing.}
\item{lower.fixed.w, upper.fixed.w}{Lower and upper confidence
  interval limits in subgroups (fixed effect model) - if
  \code{subgroup} is not missing.}
\item{statistic.fixed.w, pval.fixed.w}{z-value and p-value for test
  of effect in subgroups (fixed effect model) - if \code{subgroup} is
  not missing.}
\item{TE.random.w, seTE.random.w}{Estimated effect and standard
  error in subgroups (random effects model) - if \code{subgroup} is
  not missing.}
\item{lower.random.w, upper.random.w}{Lower and upper confidence
  interval limits in subgroups (random effects model) - if
  \code{subgroup} is not missing.}
\item{statistic.random.w, pval.random.w}{z-value or t-value and
  corresponding p-value for test of effect in subgroups (random
  effects model) - if \code{subgroup} is not missing.}
\item{w.fixed.w, w.random.w}{Weight of subgroups (in fixed and
  random effects model) - if \code{subgroup} is not missing.}
\item{df.hakn.w}{Degrees of freedom for test of effect for
  Hartung-Knapp method in subgroups - if \code{subgroup} is not
  missing and \code{hakn = TRUE}.}
\item{n.e.w}{Number of observations in experimental group in
  subgroups - if \code{subgroup} is not missing.}
\item{n.c.w}{Number of observations in control group in subgroups -
  if \code{subgroup} is not missing.}
\item{k.w}{Number of studies combined within subgroups - if
  \code{subgroup} is not missing.}
\item{k.all.w}{Number of all studies in subgroups - if \code{subgroup}
  is not missing.}
\item{Q.w.fixed}{Overall within subgroups heterogeneity statistic Q
  (based on fixed effect model) - if \code{subgroup} is not missing.}
\item{Q.w.random}{Overall within subgroups heterogeneity statistic
  Q (based on random effects model) - if \code{subgroup} is not
  missing (only calculated if argument \code{tau.common} is TRUE).}
\item{df.Q.w}{Degrees of freedom for test of overall within
  subgroups heterogeneity - if \code{subgroup} is not missing.}
\item{pval.Q.w.fixed}{P-value of within subgroups heterogeneity
  statistic Q (based on fixed effect model) - if \code{subgroup} is
  not missing.}
\item{pval.Q.w.random}{P-value of within subgroups heterogeneity
  statistic Q (based on random effects model) - if \code{subgroup} is
  not missing.}
\item{Q.b.fixed}{Overall between subgroups heterogeneity statistic
  Q (based on fixed effect model) - if \code{subgroup} is not
  missing.}
\item{Q.b.random}{Overall between subgroups heterogeneity statistic
  Q (based on random effects model) - if \code{subgroup} is not
  missing.}
\item{df.Q.b}{Degrees of freedom for test of overall between
  subgroups heterogeneity - if \code{subgroup} is not missing.}
\item{pval.Q.b.fixed}{P-value of between subgroups heterogeneity
  statistic Q (based on fixed effect model) - if \code{subgroup} is
  not missing.}
\item{pval.Q.b.random}{P-value of between subgroups heterogeneity
  statistic Q (based on random effects model) - if \code{subgroup} is
  not missing.}
\item{tau.w}{Square-root of between-study variance within subgroups
  - if \code{subgroup} is not missing.}
\item{H.w}{Heterogeneity statistic H within subgroups - if
  \code{subgroup} is not missing.}
\item{lower.H.w, upper.H.w}{Lower and upper confidence limit for
  heterogeneity statistic H within subgroups - if \code{subgroup} is
  not missing.}
\item{I2.w}{Heterogeneity statistic I\eqn{^2} within subgroups - if
  \code{subgroup} is not missing.}
\item{lower.I2.w, upper.I2.w}{Lower and upper confidence limit for
  heterogeneity statistic I\eqn{^2} within subgroups - if \code{subgroup} is
  not missing.}
\item{keepdata}{As defined above.}
\item{data}{Original data (set) used in function call (if
  \code{keepdata = TRUE}).}
\item{subset}{Information on subset of original data used in
  meta-analysis (if \code{keepdata = TRUE}).}
\item{call}{Function call.}
\item{version}{Version of R package \bold{meta} used to create
  object.}
}
\description{
Calculation of fixed effect / common effect and random effects
estimates for meta-analyses with correlations; inverse variance
weighting is used for pooling.
}
\details{
Fixed effect and random effects meta-analysis of correlations based
either on Fisher's z transformation of correlations (\code{sm =
"ZCOR"}) or direct combination of (untransformed) correlations
(\code{sm = "COR"}) (see Cooper et al., p264-5 and p273-4).  Only
few statisticians would advocate the use of untransformed
correlations unless sample sizes are very large (see Cooper et al.,
p265). The artificial example given below shows that the smallest
study gets the largest weight if correlations are combined directly
because the correlation is closest to 1.

Default settings are utilised for several arguments (assignments
using \code{\link{gs}} function). These defaults can be changed for
the current R session using the \code{\link{settings.meta}}
function.

Furthermore, R function \code{\link{update.meta}} can be used to
rerun a meta-analysis with different settings.

\subsection{Estimation of between-study variance}{

The following methods to estimate the between-study variance
\eqn{\tau^2} are available:
\itemize{
\item DerSimonian-Laird estimator (\code{method.tau = "DL"})
\item Paule-Mandel estimator (\code{method.tau = "PM"})
\item Restricted maximum-likelihood estimator (\code{method.tau =
  "REML"})
\item Maximum-likelihood estimator (\code{method.tau = "ML"})
\item Hunter-Schmidt estimator (\code{method.tau = "HS"})
\item Sidik-Jonkman estimator (\code{method.tau = "SJ"})
\item Hedges estimator (\code{method.tau = "HE"})
\item Empirical Bayes estimator (\code{method.tau = "EB"})
}
See \code{\link{metagen}} for more information on these
estimators.
}

\subsection{Confidence interval for the between-study variance}{

The following methods to calculate a confidence interval for
\eqn{\tau^2} and \eqn{\tau} are available.
\tabular{ll}{
\bold{Argument}\tab \bold{Method} \cr 
\code{method.tau.ci = "J"}\tab Method by Jackson \cr
\code{method.tau.ci = "BJ"}\tab Method by Biggerstaff and Jackson \cr
\code{method.tau.ci = "QP"}\tab Q-Profile method
}
See \code{\link{metagen}} for more information on these methods. No
confidence intervals for \eqn{\tau^2} and \eqn{\tau} are calculated
if \code{method.tau.ci = ""}.
}

\subsection{Hartung-Knapp method}{

Hartung and Knapp (2001) and Knapp and Hartung (2003) proposed an
alternative method for random effects meta-analysis based on a
refined variance estimator for the treatment estimate. Simulation
studies (Hartung and Knapp, 2001; IntHout et al., 2014; Langan et
al., 2019) show improved coverage probabilities compared to the
classic random effects method.

In rare settings with very homogeneous treatment estimates, the
Hartung-Knapp variance estimate can be arbitrarily small resulting
in a very narrow confidence interval (Knapp and Hartung, 2003;
Wiksten et al., 2016). In such cases, an
\emph{ad hoc} variance correction has been proposed by utilising
the variance estimate from the classic random effects model with
the HK method (Knapp and Hartung, 2003; IQWiQ, 2020). An
alternative approach is to use the wider confidence interval of
classic fixed or random effects meta-analysis and the HK method
(Wiksten et al., 2016; Jackson et al., 2017).

Argument \code{adhoc.hakn} can be used to choose the \emph{ad hoc}
method:
\tabular{ll}{
\bold{Argument}\tab \bold{\emph{Ad hoc} method} \cr
\code{adhoc.hakn = ""}\tab not used \cr
\code{adhoc.hakn = "se"}\tab use variance correction if HK standard
 error is smaller \cr
 \tab than standard error from classic random effects
 \cr
 \tab meta-analysis (Knapp and Hartung, 2003) \cr
\code{adhoc.hakn = "iqwig6"}\tab use variance correction if HK
 confidence interval \cr
 \tab is narrower than CI from classic random effects model \cr
 \tab with DerSimonian-Laird estimator (IQWiG, 2020) \cr
\code{adhoc.hakn = "ci"}\tab use wider confidence interval of
 classic random effects \cr
 \tab and HK meta-analysis \cr
 \tab (Hybrid method 2 in Jackson et al., 2017)
}
}

\subsection{Prediction interval}{

A prediction interval for the proportion in a new study (Higgins et
al., 2009) is calculated if arguments \code{prediction} and
\code{random} are \code{TRUE}. Note, the definition of
prediction intervals varies in the literature. This function
implements equation (12) of Higgins et al., (2009) which proposed a
\emph{t} distribution with \emph{K-2} degrees of freedom where
\emph{K} corresponds to the number of studies in the meta-analysis.
}

\subsection{Subgroup analysis}{

Argument \code{subgroup} can be used to conduct subgroup analysis for
a categorical covariate. The \code{\link{metareg}} function can be
used instead for more than one categorical covariate or continuous
covariates.
}

\subsection{Exclusion of studies from meta-analysis}{

Arguments \code{subset} and \code{exclude} can be used to exclude
studies from the meta-analysis. Studies are removed completely from
the meta-analysis using argument \code{subset}, while excluded
studies are shown in printouts and forest plots using argument
\code{exclude} (see Examples in \code{\link{metagen}}).
Meta-analysis results are the same for both arguments.
}

\subsection{Presentation of meta-analysis results}{

Internally, both fixed effect and random effects models are
calculated regardless of values choosen for arguments
\code{fixed} and \code{random}. Accordingly, the estimate
for the random effects model can be extracted from component
\code{TE.random} of an object of class \code{"meta"} even if
argument \code{random = FALSE}. However, all functions in R
package \bold{meta} will adequately consider the values for
\code{fixed} and \code{random}. E.g. functions
\code{\link{print.meta}} and \code{\link{forest.meta}} will not
print results for the random effects model if \code{random =
FALSE}.
}
}
\note{
The function \code{\link{metagen}} is called internally to
calculate individual and overall treatment estimates and standard
errors.
}
\examples{
m1 <- metacor(c(0.85, 0.7, 0.95), c(20, 40, 10))

# Print correlations (back transformed from Fisher's z
# transformation)
#
m1

# Print Fisher's z transformed correlations 
#
print(m1, backtransf = FALSE)

# Forest plot with back transformed correlations
#
forest(m1)

# Forest plot with Fisher's z transformed correlations
#
forest(m1, backtransf = FALSE)

m2 <- update(m1, sm = "cor")
m2

\dontrun{
# Identical forest plots (as back transformation is the identity
# transformation)
forest(m2)
forest(m2, backtransf = FALSE)
}

}
\references{
Cooper H, Hedges LV, Valentine JC (2009):
\emph{The Handbook of Research Synthesis and Meta-Analysis},
2nd Edition.
New York: Russell Sage Foundation

DerSimonian R & Laird N (1986):
Meta-analysis in clinical trials.
\emph{Controlled Clinical Trials},
\bold{7}, 177--88

Hartung J & Knapp G (2001):
On tests of the overall treatment effect in meta-analysis with
normally distributed responses.
\emph{Statistics in Medicine},
\bold{20}, 1771--82

Higgins JPT, Thompson SG, Spiegelhalter DJ (2009):
A re-evaluation of random-effects meta-analysis.
\emph{Journal of the Royal Statistical Society: Series A},
\bold{172}, 137--59

IntHout J, Ioannidis JPA, Borm GF (2014):
The Hartung-Knapp-Sidik-Jonkman method for random effects
meta-analysis is straightforward and considerably outperforms the
standard DerSimonian-Laird method.
\emph{BMC Medical Research Methodology},
\bold{14}, 25

IQWiG (2020):
General Methods: Version 6.0.
\url{https://www.iqwig.de/en/about-us/methods/methods-paper/}

Jackson D, Law M, Rücker G, Schwarzer G (2017): 
The Hartung-Knapp modification for random-effects meta-analysis: A
useful refinement but are there any residual concerns?
\emph{Statistics in Medicine},
\bold{36}, 3923--34

Knapp G & Hartung J (2003):
Improved tests for a random effects meta-regression with a single
covariate.
\emph{Statistics in Medicine},
\bold{22}, 2693--710

Langan D, Higgins JPT, Jackson D, Bowden J, Veroniki AA,
Kontopantelis E, et al. (2019):
A comparison of heterogeneity variance estimators in simulated
random-effects meta-analyses.
\emph{Research Synthesis Methods},
\bold{10}, 83--98

Viechtbauer W (2010):
Conducting Meta-Analyses in R with the Metafor Package.
\emph{Journal of Statistical Software},
\bold{36}, 1--48

Wiksten A, Rücker G, Schwarzer G (2016):
Hartung-Knapp method is not always conservative compared with
fixed-effect meta-analysis.
\emph{Statistics in Medicine},
\bold{35}, 2503--15
}
\seealso{
\code{\link{update.meta}}, \code{\link{metacont}},
  \code{\link{metagen}}, \code{\link{print.meta}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
