% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expression.R
\name{relativeExpr}
\alias{relativeExpr}
\title{Relative expression data (log2 counts)}
\usage{
relativeExpr(expr, power = 1)
}
\arguments{
\item{expr}{A matrix of expression data (log2 counts), with gene per row and sample per column.}

\item{power}{The power n of relative expression: (x^n/<x>)^(1/n). Default: 1.}
}
\value{
A matrix of relative log2 counts.
}
\description{
This function computes the relative gene expression (log2 counts) in a sample w.r.t all samples.
}
\examples{
data(exprMaguire)
relExpr1 <- relativeExpr(exprMaguire$expr, 1)
}
