% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/process.R
\name{filter_column_missing_rate}
\alias{filter_column_missing_rate}
\alias{filter_column_missing_rate.default}
\alias{filter_column_missing_rate.Metabolite}
\title{filter columns using missing rate}
\usage{
filter_column_missing_rate(object, threshold, verbose)

\method{filter_column_missing_rate}{default}(object, threshold = 0.5, verbose = TRUE)

\method{filter_column_missing_rate}{Metabolite}(object, threshold = 0.5, verbose = TRUE)
}
\arguments{
\item{object}{An object, data.frame, data.table or Metabolite.}

\item{threshold}{missing rate threshold, default is 0.5. Other values: 0.2, 0.8.}

\item{verbose}{print log information.}
}
\value{
An object after filtering column missing rate.
}
\description{
Remove columns below a specific missing rate threshold.
}
\examples{
data(df_plasma)
d <- filter_column_missing_rate(df_plasma)

}
