% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_Metabolite}
\alias{plot_Metabolite}
\title{plot a Metabolite object}
\usage{
plot_Metabolite(
  object,
  plot = "boxplot",
  x = "NEG",
  feature_name = NULL,
  color = "NEG",
  shape = "NEG",
  fill = "NEG",
  random_select = 16,
  size = 0.6,
  n_row = 1,
  n_col = 1,
  ylab = "featureID",
  height = 10,
  width = 10,
  save_to_file = NULL
)
}
\arguments{
\item{object}{A Metabolite object.}

\item{plot}{type of plot, current support `boxplot` and `betweenstats`.}

\item{x}{The x-axis coordinate.}

\item{feature_name}{A vector of selected metabolites to plot. If NULL, will randomly select 16 (default) metabolites to plot.}

\item{color}{A column in `@sampleData` to show the color of points.}

\item{shape}{A column in `@sampleData` to show the shape of points.}

\item{fill}{A column in `@sampleData` to show the `fill` for histogram.}

\item{random_select}{An integer, number of randomly selected metabolites to plot.}

\item{size}{Point size.}

\item{n_row}{Number of rows of subfigures for `betweenstats`}

\item{n_col}{Number of columns of subfigures for `betweenstats`}

\item{ylab}{Column name to annotate the y-axis in `betweenstats` (eg. "BIOCHEMICAL"), default column: "featureID".}

\item{height}{Height of the figure.}

\item{width}{Width of the figure.}

\item{save_to_file}{Path to save the figure.}
}
\value{
A boxplot of a Metabolite object
}
\description{
Plot a Metabolite object including boxplot (more to add.).
}
