% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/process.R
\name{replace_outlier}
\alias{replace_outlier}
\alias{replace_outlier.default}
\alias{replace_outlier.data.frame}
\alias{replace_outlier.Metabolite}
\title{change outlier values as NA or winsorize}
\usage{
replace_outlier(object, method, nSD)

\method{replace_outlier}{default}(object, method = "winsorize", nSD = 5)

\method{replace_outlier}{data.frame}(object, method = "winsorize", nSD = 5)

\method{replace_outlier}{Metabolite}(object, method = "winsorize", nSD = 5)
}
\arguments{
\item{object}{An object, a vector, data.frame, data.table or Metabolite.}

\item{method}{Replace outlier value method, the default method is `winsorize`: replace the outlier values by the maximum and/or minimum values of the remaining values. `as_NA`: set as NA (do not use this method if using half-min imputation).}

\item{nSD}{Define the N times of the SD as outliers.}
}
\value{
An object after replacing outlier values.
}
\description{
change outlier values as NA or winsorize
}
\examples{
data(df_plasma)
d <- replace_outlier(df_plasma, method = "winsorize", nSD = 5)

}
