% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metacoder-package.R
\docType{package}
\name{metacoder}
\alias{metacoder}
\title{Metacoder}
\description{
A package for planning and analysis of amplicon metagenomics research projects.
}
\details{
The goal of the \code{metacoder} package is to provide a set of tools for:

\itemize{
  \item Standardized parsing of taxonomic information from diverse resources.
  \item Visualization of statistics distributed over taxonomic classifications.
  \item Evaluating potential metabarcoding primers for taxonomic specificity.
  \item Providing flexible functions for analyzing taxonomic and abundance data.
}

To accomplish these goals, \code{metacoder} leverages resources from other R packages, interfaces with
external programs, and provides novel functions where needed to allow for entire analyses within R.
}
\section{Documentation}{


The full documentation can be found online at \url{http://grunwaldlab.github.io/metacoder_documentation}.

There is also a short vignette included for offline use that can be accessed  by the following code:

\code{browseVignettes(package = "metacoder")}

\strong{Plotting:}

\itemize{
  \item \code{\link{heat_tree}}
  \item \code{\link{heat_tree_matrix}}
}

\strong{In silico PCR:}

\itemize{
  \item \code{\link{primersearch}}
}

\strong{Analysis:}

\itemize{
  \item \code{\link{calc_taxon_abund}}
  \item \code{\link{calc_obs_props}}
  \item \code{\link{rarefy_obs}}
  \item \code{\link{compare_groups}}
  \item \code{\link{zero_low_counts}}
  \item \code{\link{calc_n_samples}}
  \item \code{\link{filter_ambiguous_taxa}}
}

\strong{Parsers:}

\itemize{
  \item \code{\link{parse_greengenes}}
  \item \code{\link{parse_mothur_tax_summary}}
  \item \code{\link{parse_mothur_taxonomy}}
  \item \code{\link{parse_newick}}
  \item \code{\link{parse_phyloseq}}
  \item \code{\link{parse_phylo}}
  \item \code{\link{parse_qiime_biom}}
  \item \code{\link{parse_rdp}}
  \item \code{\link{parse_silva_fasta}}
  \item \code{\link{parse_unite_general}}
}

\strong{Writers:}

\itemize{
  \item \code{\link{write_greengenes}}
  \item \code{\link{write_mothur_taxonomy}}
  \item \code{\link{write_rdp}}
  \item \code{\link{write_silva_fasta}}
  \item \code{\link{write_unite_general}}
}

\strong{Database querying:}

\itemize{
  \item \code{\link{ncbi_taxon_sample}}
}
}

\author{
Zachary Foster and Niklaus Grunwald
}
