% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/old_taxa--taxonomy--docs.R
\name{remove_redundant_names}
\alias{remove_redundant_names}
\title{Remove redundant parts of taxon names}
\arguments{
\item{obj}{A \code{taxonomy} or \code{taxmap} object}
}
\value{
A \code{taxonomy} or \code{taxmap} object
}
\description{
Remove the names of parent taxa in the beginning of their children's names in a \code{taxonomy} or \code{taxmap} object.
This is useful for removing genus names in species binomials.
\preformatted{
obj$remove_redundant_names()
remove_redundant_names(obj)}
}
\examples{
# Remove genus named from species taxa
species_data <- c("Carnivora;Felidae;Panthera;Panthera leo",
                  "Carnivora;Felidae;Panthera;Panthera tigris",
                  "Carnivora;Ursidae;Ursus;Ursus americanus")
obj <-  parse_tax_data(species_data, class_sep = ";")
remove_redundant_names(obj)
}
