% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readingandfes.R
\name{plot.fes}
\alias{plot.fes}
\title{Plot free energy surface object}
\usage{
\method{plot}{fes}(x, plottype = "both", colscale = F, xlim = NULL,
  ylim = NULL, zlim = NULL, main = NULL, sub = NULL, xlab = NULL,
  ylab = NULL, nlevels = 10, levels = NULL,
  col = rainbow(135)[100:1], labels = NULL, labcex = 0.6,
  drawlabels = TRUE, colscalelab = "free energy",
  method = "flattest", contcol = par("fg"), lty = par("lty"),
  lwd = 1, asp = NULL, axes = T, ...)
}
\arguments{
\item{x}{fes object.}

\item{plottype}{specifies whether 2D free energy surface will be plotted
as image, contours or both (default "both").}

\item{colscale}{specifies whether color scale will be plotted (default False).}

\item{xlim}{numeric vector of length 2, giving the x coordinates range.}

\item{ylim}{numeric vector of length 2, giving the y coordinates range.}

\item{zlim}{numeric vector of length 2, giving the z coordinates range.}

\item{main}{an overall title for the plot: see 'title'.}

\item{sub}{a sub title for the plot: see 'title'.}

\item{xlab}{a title for the x axis: see 'title'.}

\item{ylab}{a title for the y axis: see 'title'.}

\item{nlevels}{number of contour levels desired if 'levels' is not
supplied.}

\item{levels}{numeric vector of levels at which to draw contour lines.}

\item{col}{color of the free energy surface. For 1D surface it is the color
of the line. For 2D it is a list of colors such as that generated by
'rainbow', 'heat.colors', 'topo.colors', 'terrain.colors' or similar
functions (default=rainbow(135)[100:1]).}

\item{labels}{a vector giving the labels for the contour lines.  If 'NULL'
then the levels are used as labels, otherwise this is coerced
by 'as.character'.}

\item{labcex}{'cex' for contour labeling. This is an absolute size, not a
multiple of 'par("cex")'.}

\item{drawlabels}{logical. Contours are labeled if 'TRUE'.}

\item{colscalelab}{color scale label (default "free energy").}

\item{method}{character string specifying where the labels will be located.
Possible values are '"simple"', '"edge"' and '"flattest"'
(the default). See the 'Details' section.}

\item{contcol}{contour color.}

\item{lty}{line type for the lines drawn.}

\item{lwd}{contour line width.}

\item{asp}{the y/x aspect ratio, see 'plot.window'.}

\item{axes}{a logical value indicating whether both axes should be drawn
on the plot.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
`plot.fes` plots free energy surface. For a fes with one collective variable it plots
a 1D profile. For a fes with two collective variables it plots 2D free energy surface
using image, contours or combination of both (default).
}
\examples{
tfes2d<-fes(acealanme, imax=5000)
plot(tfes2d)
tfes1d<-fes(acealanme1d)
plot(tfes1d)
}
