% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_missingness.R
\name{random_missingness}
\alias{random_missingness}
\title{Random generation of missingness in a data frame.}
\usage{
random_missingness(aDataFrame, columnNames, percentMissing = 10)
}
\arguments{
\item{aDataFrame}{A data.frame where missingness will be simulated.}

\item{columnNames}{A string or a vector of strings that describe the column 
names (labels) where missingness will be simulated.}

\item{percentMissing}{The percentage of missingness within specified columns.
"Percent missing" uses a binomial distribution to simulate missing data.
Default is 10 (i.e. 10\% missing).  Use \code{\link{impute_missingness}} for
a summary of these randomly generated missing data.}
}
\value{
A data table with columns of missing data (specified as \code{NA}'s).
}
\description{
Generates random \code{NA}'s in in a column or groups of columns of a data frame.
Used in imputation simulations based on complete datasets.
}

