% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_sets.R
\name{utils_sets}
\alias{utils_sets}
\alias{set_intersect}
\alias{set_union}
\alias{set_difference}
\title{Utilities for set operations for many sets}
\usage{
set_intersect(..., pairs = FALSE)

set_union(..., pairs = FALSE)

set_difference(..., pairs = FALSE)
}
\arguments{
\item{...}{A list or a comma-separated list of vectors in the same class. If
vector contains duplicates they will be discarded. If the list doesn't have
names the sets will be named as \code{"set_1"}, "\verb{Set_2"}, \code{"Set_3"} and so on.
If vectors are given in \code{...}, the set names will be named with the names
of the objects provided.}

\item{pairs}{Returns the pairwise unions of the sets? Defaults to \code{FALSE}.}
}
\value{
A vector showing the desired operation of the sets. If \code{pairs = TRUE}, returns a list showing the pairwise operation of the sets.
}
\description{
Provides alternative function to \code{\link[base]{union}()},
\code{\link[base]{intersect}()}, and \code{\link[base]{setdiff}()}.
\itemize{
\item \code{set_union()}: Returns the union of the sets in \code{...}.
\item \code{set_intersect()}: Returns the intersect of the sets in \code{...}.
\item \code{set_difference()}: Returns the difference of the sets in \code{...}.
}
}
\examples{
\donttest{
library(metan)
(A <- letters[1:4])
(B <- letters[2:5])
(C <- letters[3:7])

set_union(A, B)
set_intersect(A, B, C)
set_difference(B, C)

}

}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
