% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/env_stratification.R
\name{plot.env_stratification}
\alias{plot.env_stratification}
\title{Plot the env_stratification model}
\usage{
\method{plot}{env_stratification}(x, var = 1, ...)
}
\arguments{
\item{x}{An object of class \code{env_stratification}}

\item{var}{The variable to plot. Defaults to \code{var = 1} the first
variable of \code{x}.}

\item{...}{Further arguments passed to \code{\link{plot.corr_coef}()}}
}
\value{
An object of class \code{gg, ggplot}.
}
\description{
This function plots the correlation between environments generated with
\code{\link{env_stratification}()}
}
\examples{
\donttest{
library(metan)
model <-
env_stratification(data_ge,
                   env = ENV,
                   gen = GEN,
                   resp = GY)
plot(model)
}
}
\seealso{
\code{\link{env_dissimilarity}}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
