% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/venn_plot.R
\name{venn_plot}
\alias{venn_plot}
\title{Draw Venn diagrams}
\usage{
venn_plot(
  ...,
  names = NULL,
  show_elements = FALSE,
  show_sets = FALSE,
  fill = ggplot_color(4),
  alpha = 0.5,
  stroke_color = "white",
  stroke_alpha = 1,
  stroke_size = 1,
  stroke_linetype = "solid",
  name_color = "black",
  name_size = 6,
  text_color = "black",
  text_size = 4,
  label_sep = ","
)
}
\arguments{
\item{...}{A list or a comma-separated list of vectors in the same class. If
vector contains duplicates they will be discarded. If the list doesn't have
names the sets will be named as \code{"set_1"}, "\verb{Set_2"}, \code{"Set_3"} and so on.
If vectors are given in \code{...}, the set names will be named with the names
of the objects provided.}

\item{names}{By default, the names of the sets are set as the names of the
objects in \code{...} (\code{names = NULL}). Use \code{names} to override this default.}

\item{show_elements}{Show set elements instead of count. Defaults to \code{FALSE}.}

\item{show_sets}{Show set names instead of count. Defaults to \code{FALSE}.}

\item{fill}{Filling colors in circles. Defaults to the default ggplot2 color
palette. A vector of length 1 will be recycled.}

\item{alpha}{Transparency for filling circles. Defaults to \code{0.5}.}

\item{stroke_color}{Stroke color for drawing circles.}

\item{stroke_alpha}{Transparency for drawing circles.}

\item{stroke_size}{Stroke size for drawing circles.}

\item{stroke_linetype}{Line type for drawing circles. Defaults to \code{"solid"}.}

\item{name_color}{Text color for set names. Defaults to \code{"black"}.}

\item{name_size}{Text size for set names.}

\item{text_color}{Text color for intersect contents.}

\item{text_size}{Text size for intersect contents.}

\item{label_sep}{The separator for labs when \code{show_elements = TRUE}. Defaults
to \code{","}.}
}
\value{
A ggplot object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Produces ggplot2-based Venn plots for 2, 3 or 4 sets. A Venn diagram shows
all possible logical relationships between several sets of data.
}
\examples{
\donttest{
library(metan)
(A <- letters[1:4])
(B <- letters[2:5])
(C <- letters[3:7])
(D <- letters[4:12])

# create a Venn plot
venn_plot(A, B)

# Three sets
venn_plot(A, B, C)

# Four sets
venn_plot(A, B, C, D)


# Use a list
dfs <- list(A = A, B = B, C = C, D = D)
venn_plot(dfs,
          show_elements = TRUE,
          fill = c("red", "blue", "green", "gray"),
          stroke_color = "black",
          alpha = 0.8,
          text_size = 8,
          label_sep = ".")
}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
