% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gafem.R
\name{plot.gafem}
\alias{plot.gafem}
\title{Several types of residual plots}
\usage{
\method{plot}{gafem}(x, ...)
}
\arguments{
\item{x}{An object of class \code{gafem}.}

\item{...}{Additional arguments passed on to the function
\code{\link{residual_plots}}}
}
\description{
Residual plots for a output model of class \code{gafem}. Seven types
of plots are produced: (1) Residuals vs fitted, (2) normal Q-Q plot for the
residuals, (3) scale-location plot (standardized residuals vs Fitted Values),
(4) standardized residuals vs Factor-levels, (5) Histogram of raw residuals
and (6) standardized residuals vs observation order, and (7) 1:1 line plot.
}
\examples{
\donttest{
library(metan)
model <- gafem(data_g, GEN, REP, PH)

plot(model)
plot(model,
     which = c(3, 5),
     nrow = 2,
     labels = TRUE,
     size.lab.out = 4,
     align = "v")
}

}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
