% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmaps.R
\name{generate_annotations_list}
\alias{generate_annotations_list}
\title{Generate annotations list}
\usage{
generate_annotations_list(
  df,
  left_bar = NULL,
  right_bar = NULL,
  top_bar = NULL,
  bottom_bar = NULL,
  left_hm = NULL,
  right_hm = NULL,
  top_hm = NULL,
  bottom_hm = NULL,
  show_legend = TRUE,
  annotation_colours = NULL
)
}
\arguments{
\item{df}{data frame containing all the data that is specified in the
remaining arguments.}

\item{left_bar}{Named list of strings, where the strings are features in
df that should be used for a barplot annotation on the left of the plot and
the names are the names that will be used to caption the plots and their
legends.}

\item{right_bar}{See left_bar.}

\item{top_bar}{See left_bar.}

\item{bottom_bar}{See left_bar.}

\item{left_hm}{Like left_bar, but with a heatmap annotation instead of a
barplot annotation.}

\item{right_hm}{See left_hm.}

\item{top_hm}{See left_hm.}

\item{bottom_hm}{See left_hm.}

\item{show_legend}{Add legends to the annotations.}

\item{annotation_colours}{Named list of heatmap annotations and their
colours.}
}
\value{
annotations_list A named list of all the annotations.
}
\description{
Intermediate function that takes in formatted lists of features and the
annotations they should be viewed through and returns annotation objects
usable by ComplexHeatmap::Heatmap.
}
\keyword{internal}
