% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groove.R
\name{overlap.prim}
\alias{overlap.prim}
\title{Overlap in primary studies across reviews}
\usage{
overlap.prim(
  x,
  ID = "factor",
  presentation = "\%",
  cut_off = c(0.05, 0.1, 0.15),
  enhanced = TRUE
)
}
\arguments{
\item{x}{an 'umbrella' object}

\item{ID}{a character variable indicating whether the overlap should be looked across 'factor' or across 'meta_review'.}

\item{presentation}{the type of presentation for the overlap. Can be precise percentages ('\%') or symbols ('+').}

\item{cut_off}{a vector of 3 cut-off values used only if the 'presentation' argument is set as '+'.}

\item{enhanced}{a logical variable indicating whether you want a narrative description of the information stored in the rows/columns returned by this function.}
}
\value{
This function returns a dataframe with 1 row/column per factor or meta-review.
As in a correlation matrix, the cell at the intersection of a row and a column contains the desired information (i.e. the overlap between primary studies for the column and row names).
}
\description{
This function allows to estimate the primary study overlap across reviews
}
\examples{
overlap.prim(umbrella(df.radua2019[sample(x = 1:250, size = 50), ],
                       mult.level=TRUE, verbose = FALSE),
             presentation = "+", cut_off = c(.05,.15,.25))
}
\references{
Pérez-Bracchiglione, J., Meza, N., Bangdiwala, S. I., Niño de Guzmán, E., Urrútia, G., Bonfill, X., & Madrid, E. (2022). Graphical Representation of Overlap for OVErviews: GROOVE tool. Research synthesis methods, 13(3), 381–388. https://doi.org/10.1002/jrsm.1557
}
