% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{interpolation_precipitation}
\alias{interpolation_precipitation}
\alias{interpolation_dewtemperature}
\alias{interpolation_temperature}
\alias{interpolation_wind}
\title{Low-level interpolation functions}
\usage{
interpolation_precipitation(
  Xp,
  Yp,
  Zp,
  X,
  Y,
  Z,
  P,
  Psmooth,
  iniRp = 140000,
  alpha_event = 6.25,
  alpha_amount = 6.25,
  N_event = 20L,
  N_amount = 20L,
  iterations = 3L,
  popcrit = 0.5,
  fmax = 0.95,
  debug = FALSE
)

interpolation_dewtemperature(
  Xp,
  Yp,
  Zp,
  X,
  Y,
  Z,
  T,
  iniRp = 140000,
  alpha = 3,
  N = 30L,
  iterations = 3L,
  debug = FALSE
)

interpolation_temperature(
  Xp,
  Yp,
  Zp,
  X,
  Y,
  Z,
  T,
  iniRp = 140000,
  alpha = 3,
  N = 30L,
  iterations = 3L,
  debug = FALSE
)

interpolation_wind(
  Xp,
  Yp,
  WS,
  WD,
  X,
  Y,
  iniRp = 140000,
  alpha = 2,
  N = 1L,
  iterations = 3L,
  directionsAvailable = TRUE
)
}
\arguments{
\item{Xp, Yp, Zp}{Spatial coordinates and elevation (Zp; in m.a.s.l) of target
points.}

\item{X, Y, Z}{Spatial coordinates and elevation (Zp; in m.a.s.l) of reference
locations (e.g. meteorological stations).}

\item{P}{Precipitation at the reference locations (in mm).}

\item{Psmooth}{Temporally-smoothed precipitation at the reference locations
(in mm).}

\item{iniRp}{Initial truncation radius.}

\item{iterations}{Number of station density iterations.}

\item{popcrit}{Critical precipitation occurrence parameter.}

\item{fmax}{Maximum value for precipitation regression extrapolations (0.6
equals to a maximum of 4 times extrapolation).}

\item{debug}{Boolean flag to show extra console output.}

\item{T}{Temperature (e.g., minimum, maximum or dew temperature) at the
reference locations (in degrees).}

\item{alpha, alpha_amount, alpha_event}{Gaussian shape parameter.}

\item{N, N_event, N_amount}{Average number of stations with non-zero weights.}

\item{WS, WD}{Wind speed (in m/s) and wind direction (in degrees from north
clock-wise) at the reference locations.}

\item{directionsAvailable}{A flag to indicate that wind directions are
available (i.e. non-missing) at the reference locations.}
}
\value{
All functions return a vector with interpolated values for the
target points.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Low-level functions to interpolate meteorology (one day) on a set of points.
}
\details{
This functions exposes internal low-level interpolation functions written in C++
not intended to be used directly in any script or function. The are maintained for
compatibility with older versions of the package and future versions of meteoland
will remove this functions (they will be still accessible through the triple colon
notation (\code{:::}), but their use is not recommended)
}
\section{Functions}{
\itemize{
\item \code{interpolation_precipitation()}: Precipitation

\item \code{interpolation_dewtemperature()}: Dew temperature

\item \code{interpolation_wind()}: Wind

}}
\examples{

Xp <- as.numeric(sf::st_coordinates(points_to_interpolate_example)[,1])
Yp <- as.numeric(sf::st_coordinates(points_to_interpolate_example)[,2])
Zp <- points_to_interpolate_example$elevation
X <- as.numeric(
  sf::st_coordinates(stars::st_get_dimension_values(meteoland_interpolator_example, "station"))[,1]
)
Y <- as.numeric(
  sf::st_coordinates(stars::st_get_dimension_values(meteoland_interpolator_example, "station"))[,2]
)
Z <- as.numeric(meteoland_interpolator_example[["elevation"]][1,])
Temp <- as.numeric(meteoland_interpolator_example[["MinTemperature"]][1,])
P <- as.numeric(meteoland_interpolator_example[["Precipitation"]][1,])
Psmooth <- as.numeric(meteoland_interpolator_example[["SmoothedPrecipitation"]][1,])
WS <- as.numeric(meteoland_interpolator_example[["WindSpeed"]][1,])
WD <- as.numeric(meteoland_interpolator_example[["WindDirection"]][1,])
iniRp <- get_interpolation_params(meteoland_interpolator_example)$initial_Rp
alpha <- get_interpolation_params(meteoland_interpolator_example)$alpha_MinTemperature
N <- get_interpolation_params(meteoland_interpolator_example)$N_MinTemperature
alpha_event <- get_interpolation_params(meteoland_interpolator_example)$alpha_PrecipitationEvent
N_event <- get_interpolation_params(meteoland_interpolator_example)$N_PrecipitationEvent
alpha_amount <- get_interpolation_params(meteoland_interpolator_example)$alpha_PrecipitationAmount
N_amount <- get_interpolation_params(meteoland_interpolator_example)$N_PrecipitationAmount
alpha_wind <- get_interpolation_params(meteoland_interpolator_example)$alpha_Wind
N_wind <- get_interpolation_params(meteoland_interpolator_example)$N_Wind
iterations <- get_interpolation_params(meteoland_interpolator_example)$iterations
popcrit <- get_interpolation_params(meteoland_interpolator_example)$pop_crit
fmax <- get_interpolation_params(meteoland_interpolator_example)$f_max
debug <- get_interpolation_params(meteoland_interpolator_example)$debug

interpolation_temperature(
  Xp, Yp, Zp,
  X[!is.na(Temp)], Y[!is.na(Temp)], Z[!is.na(Temp)],
  Temp[!is.na(Temp)],
  iniRp, alpha, N, iterations, debug
)

interpolation_wind(
  Xp, Yp,
  WS[!is.na(WD)], WD[!is.na(WD)],
  X[!is.na(WD)], Y[!is.na(WD)],
  iniRp, alpha_wind, N_wind, iterations, directionsAvailable = FALSE
)

interpolation_precipitation(
  Xp, Yp, Zp,
  X[!is.na(P)], Y[!is.na(P)], Z[!is.na(P)],
  P[!is.na(P)], Psmooth[!is.na(P)],
  iniRp, alpha_event, alpha_amount, N_event, N_amount,
  iterations, popcrit, fmax, debug
)

data("exampleinterpolationdata")
mxt100 = exampleinterpolationdata@MaxTemperature[,100]
Psmooth100 = exampleinterpolationdata@SmoothedPrecipitation[,100]
P100 = exampleinterpolationdata@Precipitation[,100]
mismxt = is.na(mxt100)
misP = is.na(P100)
Z = exampleinterpolationdata@elevation
X = exampleinterpolationdata@coords[,1]
Y = exampleinterpolationdata@coords[,2]
Zpv = seq(0,1000, by=100)
xp = 360000
yp = 4640000
xpv = rep(xp, 11)
ypv = rep(yp, 11)

interpolation_temperature(xpv, ypv, Zpv,
                          X[!mismxt], Y[!mismxt], Z[!mismxt],
                          mxt100[!mismxt])
interpolation_precipitation(xpv, ypv, Zpv,
                           X[!misP], Y[!misP], Z[!misP],
                           P100[!misP], Psmooth100[!misP])

}
\references{
Thornton, P.E., Running, S.W., White, M. A., 1997. Generating
surfaces of daily meteorological variables over large regions of complex
terrain. J. Hydrol. 190, 214–251. doi:10.1016/S0022-1694(96)03128-9.

De Caceres M, Martin-StPaul N, Turco M, Cabon A, Granda V (2018) Estimating
daily meteorological data and downscaling climate models over landscapes.
Environmental Modelling and Software 108: 186-196.
}
\seealso{
\code{\link{defaultInterpolationParams}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
