% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nullPerformance.R
\name{nullPerformance}
\alias{nullPerformance}
\title{Summarize null model performance of a series of summarized simulation results}
\usage{
nullPerformance(summarized.results, simulations = "all", metrics = "all",
  concat.by = "both")
}
\arguments{
\item{summarized.results}{The results of a call to sesIndiv() or plotOverall()}

\item{simulations}{Default is "all". Alternatively, can supply a vector of simulation
names to summarize the results over.}

\item{metrics}{Default is "all". Alternatively, can supply a vector of metric
names to summarize the results over.}

\item{concat.by}{Default is "both". Alternatively, can supply either "plot" or
"richness".}
}
\value{
A data frame of summarized results
}
\description{
Flexible function that summarizes null performance after reading in and testing
simulation results with either sesIndiv or plotOverall.
}
\details{
If an overall picture of null performance is desired, this function can
provide it. It can also be used to summarize null performance over a specific subset
of simulations, metrics, and concatenation options. If provided with the results
of a call to plotOverall, the options are more limited. Currently, if provided with
such a result, the assumption is
that there are three spatial simulations, "random", "filtering", and "competition". It
then assumes that any clustered or overdispersed plots for the random simulation,
or any overdispersed or clustered for the filtering or competition simulations,
respectively, count as typeI errors. It assumes that any plots that are not
clustered or overdispersed for the filtering or competition simulations, respectively,
count as typeII errors.
}
\examples{
#not run
#results <- readIn()
#summ <- sesIndiv(results)
#examp <- nullPerformance(summ)
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2015. Phylogenetic community
structure metrics and null models: a review with new methods and software.
bioRxiv 025726.
}

