% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_RSR.R
\name{RSR}
\alias{RSR}
\title{Root Mean Standard Deviation Ratio (RSR)}
\usage{
RSR(data = NULL, obs, pred, tidy = FALSE, na.rm = TRUE)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{Vector with observed values (numeric).}

\item{pred}{Vector with predicted values (numeric).}

\item{tidy}{Logical operator (TRUE/FALSE) to decide the type of return. TRUE
returns a data.frame, FALSE returns a list; Default : FALSE.}

\item{na.rm}{Logic argument to remove rows with missing values
(NA). Default is na.rm = TRUE.}
}
\value{
an object of class \code{numeric} within a \code{list} (if tidy = FALSE) or within a
\verb{data frame} (if tidy = TRUE).
}
\description{
It estimates the MSE normalized by the standard deviation of observed values
following Moriasi et al. (2007).
}
\details{
The RSR normalizes the Root Mean Squared Error (RMSE) using the standard
deviation of observed values. It goes from an optimal value of 0 to infinity.
Based on RSR, Moriasi et al. (2007) indicates performance ratings as:
i) very-good (0-0.50), ii) good (0.50-0.60), iii) satisfactory (0.60-0.70), or
iv) unsatisfactory (>0.70).
For the formula and more details, see \href{https://adriancorrendo.github.io/metrica/articles/available_metrics_regression.html}{online-documentation}
}
\examples{
\donttest{
set.seed(1)
X <- rnorm(n = 100, mean = 0, sd = 10)
Y <- X + rnorm(n=100, mean = 0, sd = 3)
RSR(obs = X, pred = Y)
}
}
\references{
Moriasi et al. (2007).
Model Evaluation Guidelines for Systematic Quantification of Accuracy in Watershed Simulations.
\emph{Trans. ASABE 50, 885–900.} \doi{10.13031/2013.23153}
}
