% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rail-path.R
\name{rail_path}
\alias{rail_path}
\title{Path Between Stations}
\format{
A tibble 1 row per arrival with 6 variables:
\describe{
\item{LineCode}{Two-letter abbreviation for the line (e.g.: RD, BL, YL, OR,
GR, or SV) this station's platform is on.}
\item{StationCode}{Station code for this station. Use this value in other
rail-related APIs to retrieve data about a station.}
\item{StationName}{Full name for this station, as shown on the WMATA
website.}
\item{SeqNum}{Ordered sequence number.}
\item{DistanceToPrev}{Distance in meters to the previous station in the
list, ordered by \code{SeqNum}. Converted from feet, rounded to the nearest
meter.}
}
}
\usage{
rail_path(FromStationCode, ToStationCode, api_key = wmata_key())
}
\arguments{
\item{FromStationCode}{Station code for the origin station. Use the Station
List method to return a list of all station codes.}

\item{ToStationCode}{Station code for the destination station. Use the
Station List method to return a list of all station codes.}

\item{api_key}{Subscription key which provides access to this API. Defaults
\code{Sys.getenv("WMATA_KEY")} via \code{\link[=wmata_key]{wmata_key()}}.}
}
\value{
A data frame of stations on rail path.
}
\description{
Returns a set of ordered stations and distances between two stations on the
\emph{same line}.
}
\details{
Note that this method is not suitable on its own as a pathfinding solution
between stations.
}
\examples{
\dontrun{
rail_path("A01", "A08")
}
}
\seealso{
\url{https://developer.wmata.com/docs/services/5476364f031f590f38092507/operations/5476364f031f5909e4fe330e}

Other Rail Station Information: 
\code{\link{rail_destination}()},
\code{\link{rail_entrance}()},
\code{\link{rail_lines}()},
\code{\link{rail_stations}()},
\code{\link{rail_times}()},
\code{\link{station_info}()}
}
\concept{Rail Station Information}
