\name{runstate}
\alias{runstate}
\alias{progress}
\alias{follow}
\title{Detect State of a Run Using File Existence Criteria}
\description{
	In real time, determines the status of a run generated by \code{NONR}.
}
\usage{
runstate(
	run,
	project=getwd(),
	rundir=file.path(project,run),
	testfile=c('FCON','FILE10','INTER'),
	queued=   c(0, 0, 0),
	compiled= c(1, 0, 0),
	running=  c(1, 1, 1),
	done=     c(NA,0, 1),
	...
)
progress(run,project=getwd(),...)
follow(
	run,
	project=getwd(),
	interval=10,
	watch='done',
	until=length(run),
	visible=TRUE,
	...
)
}
\arguments{
  \item{run}{a run name or number (scalar)}
  \item{project}{path to the directory containing run subdirectories}
  \item{rundir}{the path to the run directory}
  \item{testfile}{vector of filenames possibly present in \code{rundir}}
  \item{queued}{logical vector (or coercible); see details}
  \item{compiled}{logical vector (or coercible); see details}
  \item{running}{logical vector (or coercible); see details}
  \item{done}{logical vector (or coercible); see details}
  \item{interval}{integer}
  \item{watch}{character}
  \item{until}{integer}
  \item{visible}{logical}
  \item{\dots}{passed to called functions}
}

\details{
	The status of a run is either queued, compiled, running, done, or indeterminate.
	The last occurs if the run directory does not exist.  It also occurs if 
	the more than one or fewer than one of the other states is detected.
	\code{queued}, \code{compiled}, \code{running}, and \code{done} must have 
	the same length as \code{testfile} and must be coercible to \code{logical}.
	They indicate the subset of \code{testfile} that is present in \code{rundir}
	when that state applies. Obviously, they should be different from each other.
	
	\code{runstate} only analyzes one run at a time, but can be easily wrapped
	in \code{sapply}.
	
	NA in \code{queued}, \code{compiled}, \code{running}, or \code{done} indicates
	not to consider the corresponding file when testing for this state.
	
	The defaults for \code{testfile} are defined by NONMEM.  FCON: nm/ABLOCK.f.
	FILE10: nm/BLKDAT.f.  OUTPUT: nm/BEGIN.f.  \code{rlog()} tests INTER instead
	of OUTPUT if tool is 'nm7'.
	
	\code{progress} tabulates the states for one or more runs. \code{follow}
	prints the progress of one or more runs if \code{visible = TRUE}; if the element
	specified by \code{watch} is less than \code{until}, it sleeps
	\code{interval} seconds and tries again. By default, it updates status 
	at the console until all runs are 'done'.  You may need to interrupt 
	manually if any are hung.
 }
\value{
	\itemize{
	\item \code{runstate}: scalar character; one of \sQuote{queued}, \sQuote{compiled}, \sQuote{running}, 
	\sQuote{done}, or \sQuote{indeterminate}. 
	\item \code{progress}: length 5 integer vector with these names.  
	\item \code{follow}: invisible NULL.
	}
}
\references{\url{http://metrumrg.googlecode.com}}
\author{Tim Bergsma.}
\seealso{
	\itemize{
		\item \code{\link{rlog}}
	}
}
\examples{
#metrumrgURL('example/project/script/model.pdf')	
runstate(1)
}
\keyword{manip}
