% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mevr.R
\docType{data}
\name{dailyrainfall}
\alias{dailyrainfall}
\title{Daily rainfall data}
\format{
The dataset contains real world daily rainfall observations from a station 
in the northern Alps. The series contains values from 1971 to 1985 and are assumed to be 
Weibull distributed. This data series is intended to be used as is as input data 
for the package \code{mevr} to fit the metastatistical extreme value 
distribution and its variants with different estimation methods.

The dataset is a dataframe with two columns, dates and val:
 
\describe{
\item{dates}{ Days of class \code{Date} in the format YYYY-MM-DD}
\item{val}{ Rainfall observations corresponding to the date in the row. 
The value is the 24 hour sum from the morning hours of day-1 to the morning hours of day. }
}
}
\usage{
data(dailyrainfall)
}
\description{
A dataset containing daily rainfall 
intended to be used with the package \code{mevr}
}
\examples{
## Load example data
data(dailyrainfall)

## explore dataset
head(dailyrainfall)
hist(dailyrainfall$val)
plot(dailyrainfall$val, type = "o")
}
\keyword{datasets}
