% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\name{transform_vector_fp}
\alias{transform_vector_fp}
\alias{transform_vector_acd}
\title{Functions to transform a variable using fractional polynomial powers or acd}
\usage{
transform_vector_fp(
  x,
  power = 1,
  scale = 1,
  shift = 0,
  name = NULL,
  check_binary = TRUE
)

transform_vector_acd(
  x,
  power = c(1, 1),
  shift = 0,
  powers = NULL,
  scale = 1,
  acd_parameter = NULL,
  name = NULL
)
}
\arguments{
\item{x}{a vector of a predictor variable.}

\item{power}{a numeric vector indicating the FP power. Default is 1 (linear).
Must be a vector of length 2 for acd transformation. Ignores \code{NA}, unless
an ACD transformation is applied in which case power must be a numeric
vector of length 2, and \code{NA} indicated which parts are used for the final
FP.}

\item{scale}{scaling factor for x of interest. Must be a positive integer
or \code{NULL}. Default is 1, meaning no scaling is applied.
If \code{NULL}, then scaling factors are automatically estimated by the
program.}

\item{shift}{shift required for shifting x to positive values. Default is 0,
meaning no shift is applied. If \code{NULL} then the shift is estimated
automatically using the Royston and Sauerbrei formula iff any \code{x} <= 0.}

\item{name}{character used to define names for the output matrix. Default
is \code{NULL}, meaning the output will have unnamed columns.}

\item{check_binary}{a logical indicating whether or not input \code{x} is checked
if it is a binary variable (i.e. has only two distinct values). The default
\code{TRUE} usually only needs to changed when this function is to be used to
transform data for predictions. See Details.}

\item{powers}{passed to \code{\link[=fit_acd]{fit_acd()}}.}

\item{acd_parameter}{a list usually returned by \code{\link[=fit_acd]{fit_acd()}}. In particular,
it must have components that define \code{beta0}, \code{beta1}, \code{power}, \code{shift} and
\code{scale} which are to be applied when using the acd transformation in
new data.}
}
\value{
Returns a matrix of transformed variable(s). The number of columns
depends on the number of powers provided, the number of rows is equal to the
length of \code{x}. The columns are sorted by increased power.
If all powers are \code{NA}, then this function returns \code{NULL}.
In case an acd transformation is applied, the output is a list with two
entries. The first \code{acd} is the matrix of transformed variables, the acd
term is returned as the last column of the matrix (i.e. in case that the
power for the normal data is \code{NA}, then it is the only column in the matrix).
The second entry \code{acd_parameter} returns a list of estimated parameters
for the ACD transformation, or simply the input \code{acd_parameter} if it was
not \code{NULL}.
}
\description{
These functions generate fractional polynomials for a variable similar to
\code{fracgen} in Stata. \code{transform_vector_acd} generates the acd transformation
for a variable.
}
\details{
The fp transformation generally transforms \code{x} as follows. For each pi in
\code{power} = (p1, p2, ..., pn) it creates a variable x^pi and returns the
collection of variables as a matrix. It may process the data using
shifting and scaling as desired. Centering has to be done after the
data is transformed using these functions, if desired.

A special case are repeated powers, i.e. when some pi = pj. In this case,
the fp transformations are given by x^pi and x^pi * log(x). In case
more than 2 powers are repeated they are repeatedly multiplied with
log(x) terms, e.g. pi = pj = pk leads to x^pi, x^pi * log(x) and
x^pi * log(x)^2.

Note that the powers pi are assumed to be sorted. That is, this function
sorts them, then proceeds to compute the transformation. For example,
the output will be the same for \code{power = c(1, 1, 2)} and
\code{power = c(1, 2, 1)}. This is done to make sense of repeated powers and
to uniquely define FPs. In case an ACD transformation is used, there is a
specific order in which powers are processed, which is always the same (but
not necessarily sorted).
Thus, throughout the whole package powers will always be given and processed
in either sorted, or ACD specific order and the columns of the matrix
returned by this function will always align with the powers used
throughout this package.

Binary variables are not transformed, unless \code{check_binary} is set to
\code{FALSE}. This is usually not necessary, the only special case to set it to
\code{FALSE} is when a single value is to be transformed during prediction (e.g.
to transform a reference value). When this is done, binary variables are
still returned unchanged, but a single value from a continuous variable will
be transformed as desired by the fitted transformations. For model fit,
\code{check_binary} should always be at its default value.
}
\section{Functions}{
\itemize{
\item \code{transform_vector_acd()}: Function to generate acd transformation.

}}
\section{Data processing}{

An important note on data processing. Variables are shifted and scaled
before being transformed by any powers. That is to ensure positive values
and reasonable scales. Note that scaling does not change the estimated
powers, see also \code{\link[=find_scale_factor]{find_scale_factor()}}.

However, they may be centered after transformation. This is not done by
these functions.
That is to ensure that the correlation between variables stay intact,
as centering before transformation would affect them. This is described
in Sauerbrei et al (2006), as well as in the Stata manual of \code{mfp}.
Also, centering is not recommended, and should only be done for the final
model if desired.
}

\examples{
z = 1:10
transform_vector_fp(z)
transform_vector_acd(z)
}
\references{
Sauerbrei, W., Meier-Hirmer, C., Benner, A. and Royston, P., 2006.
\emph{Multivariable regression model building by using fractional
polynomials: Description of SAS, STATA and R programs.
Comput Stat Data Anal, 50(12): 3464-85.}
}
