% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contourmggd.R
\name{contourmggd}
\alias{contourmggd}
\title{Contour Plot of the Bivariate Generalised Gaussian Density}
\usage{
contourmggd(mu, Sigma, beta,
                    xlim = c(mu[1] + c(-10, 10)*Sigma[1, 1]),
                    ylim = c(mu[2] + c(-10, 10)*Sigma[2, 2]),
                    zlim = NULL, npt = 30, nx = npt, ny = npt,
                    main = "Multivariate generalised Gaussian density",
                    sub = NULL, nlevels = 10,
                    levels = pretty(zlim, nlevels), tol = 1e-6, ...)
}
\arguments{
\item{mu}{length 2 numeric vector.}

\item{Sigma}{symmetric, positive-definite square matrix of order 2. The dispersion matrix.}

\item{beta}{positive real number. The shape of the first distribution.}

\item{xlim, ylim}{x-and y- limits.}

\item{zlim}{z- limits. If NULL, it is the range of the values of the density on the x and y values within \code{xlim} and \code{ylim}.}

\item{npt}{number of points for the discretisation.}

\item{nx, ny}{number of points for the discretisation among the x- and y- axes.}

\item{main, sub}{main and sub title, as for \code{\link{title}}.}

\item{nlevels, levels}{arguments to be passed to the \code{\link{contour}} function.}

\item{tol}{tolerance (relative to largest variance) for numerical lack of positive-definiteness in Sigma, for the estimation of the density. see \code{\link{dmggd}}.}

\item{...}{additional arguments to \code{\link{plot.window}}, \code{\link{title}}, \code{\link{Axis}} and \code{\link{box}}, typically \link{graphical parameters} such as \code{cex.axis}.}
}
\value{
Returns invisibly the probability density function.
}
\description{
Draws the contour plot of the probability density of the generalised Gaussian distribution with 2 variables
with mean vector \code{mu}, dispersion matrix \code{Sigma} and shape parameter \code{beta}.
}
\examples{
mu <- c(1, 4)
Sigma <- matrix(c(0.8, 0.2, 0.2, 0.2), nrow = 2)
beta <- 0.74
contourmggd(mu, Sigma, beta)

}
\references{
E. Gomez, M. Gomez-Villegas, H. Marin. A Multivariate Generalization of the Power Exponential Family of Distribution.
Commun. Statist. 1998, Theory Methods, col. 27, no. 23, p 589-600.
\doi{10.1080/03610929808832115}
}
\seealso{
\code{\link{plotmggd}}: plot of a bivariate generalised Gaussian density.

\code{\link{dmggd}}: Probability density of a multivariate generalised Gaussian distribution.
}
\author{
Pierre Santagostini, Nizar Bouhlel
}
