% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeGoSearch_function.R
\name{makeGoSearch}
\alias{makeGoSearch}
\title{Returns gene names with a given GO term}
\usage{
makeGoSearch(mgl, term = c(""), go, saveFile = TRUE)
}
\arguments{
\item{mgl}{List; see \code{\link{buildFromNames}}, \code{\link{buildFromRegion}}, or \code{\link{buildFromEnsgs}}}

\item{term}{Character vector representing GO term of interest}

\item{go}{List produced by \code{\link{makeGo}}}

\item{saveFile}{A logical flag indicating whether a csv file ('GoSearch_[term].csv') should be saved in the current directory}
}
\description{
\code{makeGoSearch} returns a character vector of gene names.
}
\details{
Of interest maybe groups of genes that have the same GO term.
}
\examples{
exMgl() -> myMgl
makeGo(myMgl, saveFile = TRUE) -> myGo
makeGoSearch(myMgl, term = 'small molecule metabolic process', 
    go = myGo, saveFile = TRUE) -> myGoSearch

}
\seealso{
\code{\link{makeGo}}

Other output: \code{\link{makeAeiPlot}},
  \code{\link{makeCoXpGene}},
  \code{\link{makeCoXpTranscript}},
  \code{\link{makeDnaseSig}}, \code{\link{makeGo}},
  \code{\link{makeMultiEqtl}},
  \code{\link{makeOverlapTable}},
  \code{\link{makeOverlap}},
  \code{\link{makePhenotypeSearch}},
  \code{\link{makePhenotypes}},
  \code{\link{makeSnpSearch}}, \code{\link{makeSnps}},
  \code{\link{makeSummary}}
}

