% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatLimmaResult.R
\name{formatLimmaResult}
\alias{formatLimmaResult}
\title{Format a Result from Limma}
\usage{
formatLimmaResult(fit, conds, contrast)
}
\arguments{
\item{fit}{Limma fit}

\item{conds}{Condition vector}

\item{contrast}{Contrast vector}
}
\value{
A list of two dataframes : logFC and P_Value. The first one contains the logFC values of all the comparisons (one column for one comparison), the second one contains the pvalue of all the comparisons (one column for one comparison). The names of the columns for those two dataframes are identical and correspond to the description of the comparison.
}
\description{
It is not exported by DAPAR and has to be reproduced here.
}
\examples{
library(DAPAR)
set.seed(2016)
data(qData)
data(sTab)
contrast=1
sTab.old <- sTab
conds <- factor(sTab$Condition, levels = unique(sTab$Condition))
sTab <- sTab[unlist(lapply(split(sTab, conds), function(x) {
  x["Sample.name"]
})), ]
qData <- qData[, unlist(lapply(split(sTab.old, conds), function(x) {
  x["Sample.name"]
}))]
conds <- conds[order(conds)]
res.l <- NULL
design.matrix <- DAPAR::make.design(sTab)
contra <- DAPAR::make.contrast(design.matrix, condition = conds, 
                                 contrast)
cmtx <- limma::makeContrasts(contrasts = contra, levels = make.names(colnames(design.matrix)))
fit <- limma::eBayes(limma::contrasts.fit(limma::lmFit(qData, 
                                                      design.matrix), cmtx))
res.l <- mi4p::formatLimmaResult(fit, conds, contrast)
}
\author{
Adapted from the code of Samuel Wieczorek in the DAPAR package as it is an object that is not exported by the DAPAR package.
}
