% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meanImp_emmeans.R
\name{meanImp_emmeans}
\alias{meanImp_emmeans}
\title{Multiple Imputation Estimate}
\usage{
meanImp_emmeans(ind, peptide = 1, tabdata, metacond)
}
\arguments{
\item{ind}{index}

\item{peptide}{name of the peptide}

\item{tabdata}{dataset}

\item{metacond}{a factor to specify the groups}
}
\value{
A vector.
}
\description{
Computes the multiple imputation parameter estimate using the emmeans package.
}
\examples{
library(mi4p)
data(datasim)
datasim_imp <- multi.impute(data = datasim[,-1], conditions = 
attr(datasim,"metadata")$Condition, method = "MLE")
meanImp_emmeans(1,1,datasim_imp,attr(datasim,"metadata")$Condition)
}
\references{
M. Chion, Ch. Carapito and F. Bertrand (2021). \emph{Accounting for multiple imputation-induced variability for differential analysis in mass spectrometry-based label-free quantitative proteomics}. arxiv:2108.07086. \url{https://arxiv.org/abs/2108.07086}.
}
